/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.advisory.constant;

import com.google.common.collect.Maps;
import java.util.Map;

public enum AdvisoryType {
    TRIAL_COURSE(0, "\u9884\u7ea6\u8bd5\u542c", "cdb.org_course"),
    TEL_ADVISORY(1, "\u6765\u7535\u54a8\u8be2", "cdb.org_course"),
    CLASS_COURSE_ADVISORY(2, "\u73ed\u8bfe\u54a8\u8be2", "cdb.teacher_class_course"),
    ORG_ADVISORY(3, "\u673a\u6784\u4e3b\u9875", "yunying.org_account"),
    TEACHER(4, "\u8001\u5e08\u54a8\u8be2", "cdb.teacher"),
    TEACHER_COURSE(5, "\u4e00\u5bf9\u4e00\u54a8\u8be2", "cdb.teacher_course");

    private int code;
    private String note;
    private String table;
    private static Map<Integer, AdvisoryType> map;
    private static Map<String, AdvisoryType> tableMap;

    private AdvisoryType(int code, String note) {
        this.code = code;
        this.note = note;
    }

    private AdvisoryType(int code, String note, String table) {
        this.code = code;
        this.note = note;
        this.table = table;
    }

    public String getTable() {
        return this.table;
    }

    public int getCode() {
        return this.code;
    }

    public String getNote() {
        return this.note;
    }

    public static AdvisoryType getTypeByCode(Integer code) {
        return map.get(code);
    }

    public static AdvisoryType getTypeByCode(String table) {
        return tableMap.get(table);
    }

    static {
        map = Maps.newHashMap();
        tableMap = Maps.newHashMap();
        for (AdvisoryType at : AdvisoryType.values()) {
            map.put(at.code, at);
            tableMap.put(at.table, at);
        }
    }
}

