/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.wechat.dao.impl;

import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class FansDaoImpl
extends JdbcTemplateDaoSupport<Fans>
implements FansDao {
    public FansDaoImpl() {
        super(Fans.class);
    }

    @Override
    public Fans getByOpenId(String openId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("openId", (Serializable)((Object)openId));
        return (Fans)this.uniqueResult(builder);
    }

    @Override
    public List<Fans> search(String authorizerAppId, String searchText, PageDto pageDto) {
        final ArrayList<Fans> list = new ArrayList<Fans>();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT * FROM yunying.org_wechat_fans WHERE authorizer_app_id=:authorizerAppId ");
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            builder.append(" AND IF(remark!='',remark,nick) LIKE :searchText");
        }
        builder.append(" ORDER BY last_communication_time DESC, subscribe_time DESC");
        if (pageDto != null) {
            builder.append(" LIMIT :start,:size");
        }
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("authorizerAppId", authorizerAppId);
        params.put("searchText", "%" + searchText + "%");
        if (pageDto != null) {
            params.put("start", pageDto.firstNum());
            params.put("size", pageDto.getPageSize());
        }
        template.query(builder.toString(), params, (RowMapper)new RowMapper<Integer>(){
            Fans fans;

            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                this.fans = new Fans();
                this.fans.setAuthorizerAppId(rs.getString("authorizer_app_id"));
                this.fans.setCity(rs.getString("city"));
                this.fans.setCountry(rs.getString("country"));
                this.fans.setCreateTime(rs.getTimestamp("create_time"));
                this.fans.setGroupId(rs.getInt("groug_id"));
                this.fans.setHeadImgUrl(rs.getString("head_img_url"));
                this.fans.setId(rs.getInt("id"));
                this.fans.setIsDel(rs.getInt("is_del"));
                this.fans.setLanguage(rs.getString("language"));
                this.fans.setLastCommunicationTime(rs.getTimestamp("last_communication_time"));
                this.fans.setNick(rs.getString("nick"));
                this.fans.setOpenId(rs.getString("open_id"));
                this.fans.setProvince(rs.getString("province"));
                this.fans.setRemark(rs.getString("remark"));
                this.fans.setSex(rs.getInt("sex"));
                this.fans.setSubscribe(rs.getInt("subscribe"));
                this.fans.setSubscribeTime(rs.getTimestamp("subscribe_time"));
                this.fans.setUpdateTime(rs.getTimestamp("update_time"));
                list.add(this.fans);
                return 1;
            }
        });
        return list;
    }

    @Override
    public Integer count(String authorizerAppId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("authorizerAppId", (Serializable)((Object)authorizerAppId));
        builder.count("id");
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public Map<String, Integer> checkOpenIdExist(List<String> openIds) {
        final HashMap<String, Integer> map = new HashMap<String, Integer>();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT id,open_id FROM yunying.org_wechat_fans WHERE open_id IN(:openIds)");
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("openIds", openIds);
        template.query(builder.toString(), params, (RowMapper)new RowMapper<Integer>(){

            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                map.put(rs.getString("open_id"), rs.getInt("id"));
                return 1;
            }
        });
        return map;
    }

    @Override
    public Integer countSubscribe(String authorizerAppId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("authorizerAppId", (Serializable)((Object)authorizerAppId));
        builder.eq("subscribe", (Serializable)Integer.valueOf(1));
        builder.count("id");
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public Map<String, Fans> mapKeyOpenIdValueFans(List<String> openIds) {
        final HashMap<String, Fans> map = new HashMap<String, Fans>();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT * FROM yunying.org_wechat_fans WHERE open_id IN(:openIds)");
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("openIds", openIds);
        template.query(builder.toString(), params, (RowMapper)new RowMapper<Integer>(){
            Fans fans;

            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                this.fans = new Fans();
                this.fans.setAuthorizerAppId(rs.getString("authorizer_app_id"));
                this.fans.setCity(rs.getString("city"));
                this.fans.setCountry(rs.getString("country"));
                this.fans.setCreateTime(rs.getTimestamp("create_time"));
                this.fans.setGroupId(rs.getInt("groug_id"));
                this.fans.setHeadImgUrl(rs.getString("head_img_url"));
                this.fans.setId(rs.getInt("id"));
                this.fans.setIsDel(rs.getInt("is_del"));
                this.fans.setLanguage(rs.getString("language"));
                this.fans.setLastCommunicationTime(rs.getTimestamp("last_communication_time"));
                this.fans.setNick(rs.getString("nick"));
                this.fans.setOpenId(rs.getString("open_id"));
                this.fans.setProvince(rs.getString("province"));
                this.fans.setRemark(rs.getString("remark"));
                this.fans.setSex(rs.getInt("sex"));
                this.fans.setSubscribe(rs.getInt("subscribe"));
                this.fans.setSubscribeTime(rs.getTimestamp("subscribe_time"));
                this.fans.setUpdateTime(rs.getTimestamp("update_time"));
                map.put(this.fans.getOpenId(), this.fans);
                return 1;
            }
        });
        return map;
    }
}

