/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.sync.dao.impl;

import com.baijia.tianxiao.dal.sync.dao.TxConsultUserStatMonthDao;
import com.baijia.tianxiao.dal.sync.po.TxConsultUserStatMonth;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class TxConsultUserStatMonthDaoImpl
extends JdbcTemplateDaoSupport<TxConsultUserStatMonth>
implements TxConsultUserStatMonthDao {
    private static final Logger log = LoggerFactory.getLogger(TxConsultUserStatMonthDaoImpl.class);

    public TxConsultUserStatMonthDaoImpl() {
        super(TxConsultUserStatMonth.class);
    }

    @Override
    public int countByOrgSource(Long orgId, int sourceType, Date startTime, Date endTime) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.sum("number");
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("sourceType", (Serializable)Integer.valueOf(sourceType));
        builder.ge("createTime", (Serializable)startTime);
        builder.lt("createTime", (Serializable)endTime);
        log.info("count by org source sql= {},params:{orgId={},sourceType={},startTime={},endTime={}}", new Object[]{builder.toSql(), orgId, sourceType, startTime, endTime});
        Integer num = (Integer)this.queryForObject(builder, Integer.class);
        return num == null ? 0 : num;
    }

    @Override
    public int countByOrgConsultStatus(Long orgId, int status, int monthDiff) {
        HashMap params = Maps.newHashMap();
        params.put("orgId", orgId);
        params.put("monthDiff", monthDiff);
        params.put("status", status);
        StringBuilder sb = new StringBuilder("select count(1) from (select count(1) from yunying.tx_consult_stat_month");
        sb.append(" where org_id = :orgId");
        sb.append(" and  date_format(create_time,'%Y-%m')=date_format(DATE_SUB(curdate(), INTERVAL :monthDiff MONTH),'%Y-%m') and status>=:status group by consult_user_id,user_id) a");
        log.info("countByOrgConsultStatus sql= {},params:{orgId={},monthDiff={},status={}}", new Object[]{sb.toString(), orgId, monthDiff, status});
        return (Integer)this.getNamedJdbcTemplate().queryForObject(sb.toString(), (Map)params, Integer.class);
    }

    @Override
    public TxConsultUserStatMonth getTxConsultStatByQuery(long orgId, long consultUserId, long userId, int sourceType, Date startTime, Date endTime) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)Long.valueOf(orgId));
        if (consultUserId != 0L) {
            builder.eq("consultUserId", (Serializable)Long.valueOf(consultUserId));
        } else {
            builder.eq("userId", (Serializable)Long.valueOf(userId));
        }
        builder.eq("sourceType", (Serializable)Integer.valueOf(sourceType));
        builder.ge("createTime", (Serializable)startTime);
        builder.lt("createTime", (Serializable)endTime);
        builder.setMaxSize(Integer.valueOf(1));
        builder.desc("createTime");
        return (TxConsultUserStatMonth)this.uniqueResult(builder);
    }

    @Override
    public int countByTime(long orgId, Date startTime, Date endTime) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)Long.valueOf(orgId));
        builder.sum("number");
        builder.ge("updateTime", (Serializable)startTime);
        builder.lt("updateTime", (Serializable)endTime);
        builder.group("orgId");
        return (Integer)this.queryForObject(builder, Integer.class);
    }
}

