/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.course.dao.impl;

import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupRelateDao;
import com.baijia.tianxiao.dal.course.po.OrgCourseGroupRelate;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository(value="orgCourseGroupRelateDao")
public class OrgCourseGroupRelateDaoImpl
extends JdbcTemplateDaoSupport<OrgCourseGroupRelate>
implements OrgCourseGroupRelateDao {
    private static final Logger logger = LoggerFactory.getLogger(OrgCourseGroupRelateDaoImpl.class);

    public OrgCourseGroupRelateDaoImpl() {
        super(OrgCourseGroupRelate.class);
    }

    @Override
    public List<OrgCourseGroupRelate> getOrgCourseGroup(Integer orgId, PageDto pageDto) {
        String sql = "select oc.* from org_course_group og,org_course_group_relate oc where og.org_id=? and og.id=oc.course_group_id and oc.is_deleted=1 and course_type!=0 order by oc.display_order desc";
        return this.getNamedJdbcTemplate().getJdbcOperations().query(sql, new Object[]{orgId}, (RowMapper)BeanPropertyRowMapper.newInstance(OrgCourseGroupRelate.class));
    }

    @Override
    public List<Long> getCourseIdsByGroup(Integer courseGroupId, Integer courseType) {
        try {
            SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
            builder.select("courseId");
            builder.eq("courseGroupId", (Serializable)courseGroupId);
            builder.eq("courseType", (Serializable)courseType);
            builder.eq("isDeleted", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
            builder.desc("displayOrder");
            return this.queryForList(builder, Long.class);
        }
        catch (Exception e) {
            logger.info("courseGroupId:{}, courseType:{}, e:{}", new Object[]{courseGroupId, courseType, e});
            return Collections.emptyList();
        }
    }

    @Override
    public OrgCourseGroupRelate getCourseGroupByCourseId(Integer courseGroupId, Integer courseType, Long courseId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("courseId", (Serializable)courseId);
        builder.eq("courseGroupId", (Serializable)courseGroupId);
        builder.eq("courseType", (Serializable)courseType);
        builder.eq("isDeleted", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return (OrgCourseGroupRelate)this.uniqueResult(builder);
    }

    @Override
    public int getMaxDisplayOrderByExcludeIds(Integer courseGroupId, Collection<Long> excludeIds) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.max("displayOrder");
        builder.eq("courseGroupId", (Serializable)courseGroupId);
        builder.eq("isDeleted", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.notin("courseId", excludeIds);
        Integer count = (Integer)this.queryForObject(builder, Integer.class);
        return count == null ? 0 : count;
    }
}

