/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.activity.dao.impl;

import com.baijia.tianxiao.dal.activity.dao.ActivityAccessLogDao;
import com.baijia.tianxiao.dal.activity.po.ActivityAccessLog;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

@Repository
public class ActivityAccessLogDaoImpl
extends JdbcTemplateDaoSupport<ActivityAccessLog>
implements ActivityAccessLogDao {
    private static final Logger logger = LoggerFactory.getLogger(ActivityAccessLogDaoImpl.class);

    public ActivityAccessLogDaoImpl() {
        super(ActivityAccessLog.class);
    }

    @Override
    public List<ActivityAccessLog> selectActivityAccessLogByDate(List<String> dateList, Long activityId, int category) {
        if (dateList == null || dateList.isEmpty()) {
            return Collections.emptyList();
        }
        SingleSqlBuilder sb = this.createSqlBuilder(new String[0]);
        sb.in("accessDate", dateList);
        sb.eq("activityId", (Serializable)activityId);
        sb.eq("category", (Serializable)Integer.valueOf(category));
        return this.queryList(sb);
    }

    @Override
    public Map<Long, Integer> selectTotalByActivityId(List<Long> activityIds, int category) {
        String sql = "select activity_id,sum(access_count) as count from yunying.tx_activity_access_log where activity_id in (:activityIds) and category=:category group by activity_id";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("activityIds", activityIds);
        param.put("category", category);
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, Integer>>(){

            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, Integer> map = new HashMap<Long, Integer>();
                while (rs.next()) {
                    map.put(rs.getLong("activity_id"), rs.getInt("count"));
                }
                return map;
            }
        });
    }

    @Override
    public void insertActivityAccessLog(ActivityAccessLog log) {
        this.save(log, new String[0]);
    }

    @Override
    public void updateActivityAccessLog(Long activityId, String accessDate) {
        String sql = "update yunying.tx_activity_access_log set access_count = access_count+1 where activity_id=:activityId and access_date=:accessDate";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("activityId", activityId);
        param.put("accessDate", accessDate);
        this.getNamedJdbcTemplate().update(sql, param);
    }
}

