/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.todo.dao.impl;

import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.todo.dao.TxBacklogDao;
import com.baijia.tianxiao.dal.todo.po.TxBacklog;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class TxBacklogDaoImpl
extends JdbcTemplateDaoSupport<TxBacklog>
implements TxBacklogDao {
    public TxBacklogDaoImpl() {
        super(TxBacklog.class);
    }

    @Override
    public List<TxBacklog> getBacklogListByRemindTime(Date startTime, Date endTime) {
        Preconditions.checkArgument((endTime != null ? 1 : 0) != 0, (Object)"endTime can't be null");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.isNotNull("remindTime");
        if (startTime != null) {
            builder.ge("remindTime", (Serializable)startTime);
        }
        builder.lt("remindTime", (Serializable)endTime);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.eq("finish", (Serializable)BizConf.FALSE);
        builder.asc("id");
        return this.queryList(builder);
    }

    @Override
    public List<TxBacklog> getBacklogListByGroup(Long orgId, Integer groupType, PageDto page, String ... queryProps) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((groupType != null && groupType >= 0 && groupType <= 3 ? 1 : 0) != 0, (Object)"groupType is illegal!");
        Date currentDate = DateUtil.getDayDiff((int)0);
        Date tomorrowDate = DateUtil.getDayDiff((int)1);
        Date furtherDate = DateUtil.getDayDiff((int)8);
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        switch (groupType) {
            case 0: {
                builder.ge("endTime", (Serializable)currentDate);
                builder.lt("endTime", (Serializable)tomorrowDate);
                break;
            }
            case 1: {
                builder.ge("endTime", (Serializable)tomorrowDate);
                builder.lt("endTime", (Serializable)furtherDate);
                break;
            }
            case 2: {
                builder.ge("endTime", (Serializable)furtherDate);
                break;
            }
            case 3: {
                builder.lt("endTime", (Serializable)currentDate);
                break;
            }
        }
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.setPage(page);
        builder.asc("endTime");
        return this.queryList(builder);
    }

    @Override
    public TxBacklog getBacklogByIdAndOrgId(Long id, Long orgId, String ... queryProps) {
        Preconditions.checkArgument((null != id && id > 0L ? 1 : 0) != 0, (Object)"id can't be null");
        Preconditions.checkArgument((null != orgId && orgId > 0L ? 1 : 0) != 0, (Object)"orgId can't be null");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("id", (Serializable)id);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return (TxBacklog)this.uniqueResult(builder);
    }

    @Override
    public List<TxBacklog> getBacklogByConsulterIdAndOrgId(Long consulterId, Long orgId, Boolean expired, String ... queryProps) {
        Preconditions.checkArgument((null != consulterId && consulterId > 0L ? 1 : 0) != 0, (Object)"consulterId can't be null");
        Preconditions.checkArgument((null != orgId && orgId > 0L ? 1 : 0) != 0, (Object)"orgId can't be null");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        if (null != expired) {
            if (expired.booleanValue()) {
                builder.lt("endTime", (Serializable)new Date());
            } else {
                builder.ge("endTime", (Serializable)new Date());
            }
        }
        builder.eq("consultUserId", (Serializable)consulterId);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("isSys", (Serializable)BizConf.TRUE);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public List<TxBacklog> getBacklogByStudentIdAndOrgId(Long studentId, Long orgId, Boolean expired, String ... queryProps) {
        Preconditions.checkArgument((null != studentId && studentId > 0L ? 1 : 0) != 0, (Object)"studentId can't be null");
        Preconditions.checkArgument((null != orgId && orgId > 0L ? 1 : 0) != 0, (Object)"orgId can't be null");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        if (null != expired) {
            if (expired.booleanValue()) {
                builder.lt("endTime", (Serializable)DateUtil.getCurrentDate());
            } else {
                builder.ge("endTime", (Serializable)DateUtil.getCurrentDate());
            }
        }
        builder.eq("studentId", (Serializable)studentId);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("isSys", (Serializable)BizConf.TRUE);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }
}

