/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.roster.dao.impl;

import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.Expression;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.sqlbuilder.util.Expressions;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class TxConsultUserDaoImpl
extends JdbcTemplateDaoSupport<TxConsultUser>
implements TxConsultUserDao {
    public TxConsultUserDaoImpl() {
        super(TxConsultUser.class);
    }

    @Override
    public List<TxConsultUser> lookByUserId(Long orgId, Long useId, String ... queryProp) {
        if (useId == null || useId == 0L) {
            return Collections.emptyList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(queryProp);
        builder.eq("userId", (Serializable)useId);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public List<TxConsultUser> lookByStudentId(Long orgId, Long studentId, String ... queryProp) {
        if (studentId == null || studentId == 0L) {
            return Collections.emptyList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(queryProp);
        builder.eq("studentId", (Serializable)studentId);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.desc("createTime");
        return this.queryList(builder);
    }

    @Override
    public List<TxConsultUser> lookByMobile(Long orgId, String mobile, String ... queryProp) {
        if (StringUtils.isBlank((CharSequence)mobile)) {
            return Collections.emptyList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(queryProp);
        builder.eq("mobile", (Serializable)((Object)mobile));
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public List<TxConsultUser> lookByWeixinOpenId(Long orgId, String weixinOpenId, String ... queryProp) {
        if (StringUtils.isBlank((CharSequence)weixinOpenId)) {
            return Collections.emptyList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(queryProp);
        builder.eq("weixinOpenId", (Serializable)((Object)weixinOpenId));
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public List<TxConsultUser> lookByMobiles(final Long orgId, Collection<String> mobiles, final String ... queryProp) {
        if (CollectionUtils.isEmpty(mobiles)) {
            return Collections.emptyList();
        }
        return (List)new ListBatchQueryTemplate().batchQuery(mobiles, (BatchQueryCallback)new BatchQueryCallback<String, List<TxConsultUser>>(){

            public List<TxConsultUser> doQuery(Collection<String> querySet) {
                SingleSqlBuilder builder = TxConsultUserDaoImpl.this.createSqlBuilder(queryProp);
                builder.in("mobile", querySet);
                builder.eq("orgId", (Serializable)orgId);
                builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
                return TxConsultUserDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public List<TxConsultUser> lookByWeixinOpenIds(final Long orgId, Collection<String> weixinOpenIds, final String ... queryProp) {
        if (CollectionUtils.isEmpty(weixinOpenIds)) {
            return Collections.emptyList();
        }
        return (List)new ListBatchQueryTemplate().batchQuery(weixinOpenIds, (BatchQueryCallback)new BatchQueryCallback<String, List<TxConsultUser>>(){

            public List<TxConsultUser> doQuery(Collection<String> querySet) {
                SingleSqlBuilder builder = TxConsultUserDaoImpl.this.createSqlBuilder(queryProp);
                builder.in("mobile", querySet);
                builder.eq("orgId", (Serializable)orgId);
                builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
                return TxConsultUserDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public List<TxConsultUser> search(Integer type, String key, Long orgId, Integer intensionLevel, Collection<Integer> consultSources, Date startTime, Date endTime, PageDto page, String ... queryProp) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((type == null || type != null && (type == 0 || type == 1) ? 1 : 0) != 0, (Object)"type is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProp);
        if (type != null) {
            if (0 == type) {
                builder.eq("studentId", (Serializable)Integer.valueOf(0));
            } else if (1 == type) {
                builder.gt("studentId", (Serializable)Integer.valueOf(0));
            }
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{key})) {
            Expression exp = Expressions.like((String)"name", (Serializable)((Object)key), (MatchMode)MatchMode.ANYWHERE);
            exp = Expressions.or((Expression)exp, (Expression)Expressions.like((String)"nickName", (Serializable)((Object)key), (MatchMode)MatchMode.ANYWHERE));
            exp = Expressions.or((Expression)exp, (Expression)Expressions.like((String)"weixinNickName", (Serializable)((Object)key), (MatchMode)MatchMode.ANYWHERE));
            if (StringUtils.isNumeric((CharSequence)key)) {
                exp = Expressions.or((Expression)exp, (Expression)Expressions.like((String)"mobile", (Serializable)((Object)key), (MatchMode)MatchMode.ANYWHERE));
            }
            builder.add(exp);
        }
        if (intensionLevel != null) {
            builder.eq("intensionLevel", (Serializable)intensionLevel);
        }
        if (CollectionUtils.isNotEmpty(consultSources)) {
            builder.in("consultSource", consultSources);
        }
        if (startTime != null) {
            builder.ge("createTime", (Serializable)startTime);
        }
        if (endTime != null) {
            builder.ge("createTime", (Serializable)endTime);
        }
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.setPage(page);
        builder.desc("createTime");
        return this.queryList(builder);
    }

    @Override
    public List<TxConsultUser> getOrgConsultUserListByMinId(Long minId, Date lastDate, int maxSize, String ... queryProps) {
        Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0, (Object)"maxSize is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        if (minId == null || minId == 0L) {
            if (lastDate == null) {
                throw new IllegalArgumentException("must have minId or lastDate");
            }
            builder.gt("createTime", (Serializable)lastDate);
        } else {
            builder.gt("id", (Serializable)minId);
        }
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.asc("createTime");
        builder.setMaxSize(Integer.valueOf(maxSize));
        return this.queryList(builder);
    }

    @Override
    public List<TxConsultUser> getOrgConsultUserListByUpdateTime(Long minId, Date lastDate, int maxSize, String ... queryProps) {
        Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0, (Object)"maxSize is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.gt("updateTime", (Serializable)lastDate);
        builder.asc("updateTime");
        builder.setMaxSize(Integer.valueOf(maxSize));
        return this.queryList(builder);
    }

    @Override
    public Map<String, Long> mapKeyOpenIdValueId(Integer orgId, List<String> openIdList) {
        final HashMap<String, Long> map = new HashMap<String, Long>();
        String sql = "SELECT id,weixin_open_id FROM yunying.tx_consult_user WHERE org_id=:orgId AND weixin_open_id IN(:openIdList) AND del_status=0";
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("openIdList", openIdList);
        template.query(sql, params, (RowMapper)new RowMapper<Integer>(){

            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                map.put(rs.getString("weixin_open_id"), rs.getLong("id"));
                return 1;
            }
        });
        return map;
    }

    @Override
    public List<TxConsultUser> getConsultUserByRemindTime(Date startTime) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"id", "orgId", "userId", "name", "nickName"});
        builder.lt("nextRemindTime", (Serializable)new Date());
        builder.gt("nextRemindTime", (Serializable)startTime);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public List<TxConsultUser> getConsultUserByRemindTime(Date startTime, Date endTime) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"id", "orgId", "userId", "name", "nickName"});
        builder.lt("nextRemindTime", (Serializable)endTime);
        builder.ge("nextRemindTime", (Serializable)startTime);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public TxConsultUser getOrgConsultUser(Long orgId, Long id) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("id", (Serializable)id);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return (TxConsultUser)this.uniqueResult(builder);
    }

    @Override
    public List<TxConsultUser> searchHasMobileConsulter(PageDto pageDto, String format, String value) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.ne("mobile", (Serializable)((Object)""));
        builder.dateformat("birthday", format, value);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.group("mobile");
        builder.setPage(pageDto);
        return this.queryList(builder);
    }

    @Override
    public List<TxConsultUser> lookByParams(Long orgId, String weixinOpenId, String ... queryProp) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProp);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("weixinOpenId", (Serializable)((Object)weixinOpenId));
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.desc("createTime");
        return this.queryList(builder);
    }

    @Override
    public TxConsultUser lookByParams(Long orgId, String mobile, String weixinOpenId, String ... queryProp) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProp);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("mobile", (Serializable)((Object)mobile));
        builder.eq("weixinOpenId", (Serializable)((Object)weixinOpenId));
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return (TxConsultUser)this.uniqueResult(builder);
    }
}

