/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.course.dao.impl;

import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupDao;
import com.baijia.tianxiao.dal.course.po.OrgCourseGroup;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository(value="orgCourseGroupDao")
public class OrgCourseGroupDaoImpl
extends JdbcTemplateDaoSupport<OrgCourseGroup>
implements OrgCourseGroupDao {
    public OrgCourseGroupDaoImpl() {
        super(OrgCourseGroup.class);
    }

    @Override
    public List<OrgCourseGroup> getOrgCourseGroupList(Integer orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("isDeleted", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.desc("displayOrder");
        return this.queryList(builder);
    }

    @Override
    public List<String> getDistinctSubject(Integer orgId, PageDto pageDto) {
        String sql = "select distinct name from yunying.org_course_group_relate oc,yunying.org_course_group og where oc.course_group_id=og.id and og.org_id=? and oc.is_deleted=0 order by og.display_order desc limit ?, ?";
        List names = this.getNamedJdbcTemplate().getJdbcOperations().query(sql, new Object[]{orgId, pageDto.firstNum(), pageDto.getPageSize()}, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString("name");
            }
        });
        return names;
    }

    @Override
    public int countByName(Integer orgId, String name) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("name", (Serializable)((Object)name));
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("isDeleted", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.count("id");
        return (Integer)this.queryForObject(builder, Integer.class);
    }
}

