/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.activity.dao.draw.impl;

import com.baijia.tianxiao.dal.activity.dao.draw.WinnerDao;
import com.baijia.tianxiao.dal.activity.dto.PageInfo;
import com.baijia.tianxiao.dal.activity.po.draw.Winner;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

@Repository
public class WinnerDaoImpl
extends JdbcTemplateDaoSupport<Winner>
implements WinnerDao {
    public WinnerDaoImpl() {
        super(Winner.class);
    }

    @Override
    public Long insertWinner(Winner winner) {
        this.save(winner, new String[0]);
        return winner.getDrawId();
    }

    @Override
    public List<Winner> selectWinnerListByPage(long activityId, PageInfo page) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("activityId", (Serializable)Long.valueOf(activityId));
        if (page != null) {
            if (page.getLastId() != null && page.getLastId() > 0L) {
                builder.lt("id", (Serializable)page.getLastId());
            }
            builder.setPage(page.getPageDto());
        }
        builder.desc("createTime");
        return this.queryList(builder);
    }

    @Override
    public Map<Long, Integer> selectTotalByActivityId(List<Long> activityIds) {
        String sql = "select activity_id,count(id) as count from yunying.tx_activity_winner where activity_id in (:activityIds) group by activity_id";
        HashMap<String, List<Long>> param = new HashMap<String, List<Long>>();
        param.put("activityIds", activityIds);
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, Integer>>(){

            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, Integer> map = new HashMap<Long, Integer>();
                while (rs.next()) {
                    map.put(rs.getLong("activity_id"), rs.getInt("count"));
                }
                return map;
            }
        });
    }

    @Override
    public void updateCheckInInfo(Winner winner) {
        String sql = "update yunying.tx_activity_winner set name = :name,mobile=:mobile,address=:address,check_in_time=:checkInTime where id=:id";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("name", winner.getName());
        param.put("mobile", winner.getMobile());
        param.put("address", winner.getAddress());
        param.put("checkInTime", new Date());
        param.put("id", winner.getDrawId());
        this.getNamedJdbcTemplate().update(sql, param);
    }

    @Override
    public Winner selectWinnerById(Long drawId) {
        return (Winner)this.getById(drawId, new String[0]);
    }

    @Override
    public Map<Integer, Integer> selectPrizesByDate(long activityId, Date startTime, Date endTime) {
        String sql = "select grade,count(id) as count from yunying.tx_activity_winner where activity_id = :activityId and create_time between :startTime and :endTime group by grade";
        HashMap<String, Comparable<Long>> param = new HashMap<String, Comparable<Long>>();
        param.put("activityId", Long.valueOf(activityId));
        param.put("startTime", startTime);
        param.put("endTime", endTime);
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Integer, Integer>>(){

            public Map<Integer, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Integer, Integer> retMap = new HashMap<Integer, Integer>();
                while (rs.next()) {
                    retMap.put(rs.getInt("grade"), rs.getInt("count"));
                }
                return retMap;
            }
        });
    }
}

