/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.wechat.po;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

@Entity
@Table(name="org_wechat_authorization_info", catalog="yunying")
public class AuthorizationInfo {
    @Id
    @GeneratedValue
    private Integer id;
    @Column(name="org_id")
    private Integer orgId;
    @Column(name="authorizer_app_id")
    private String authorizerAppId;
    @Column(name="authorizer_access_token")
    private String authorizerAccessToken;
    @Column(name="authorizer_refresh_token")
    private String authorizerRefershToken;
    @Column(name="expires_in")
    private Integer expiresIn;
    @Column(name="funcs")
    private String funcs;
    @Column(name="create_time")
    private Date createTime;
    @Column(name="update_time")
    private Date updateTime;

    public boolean isAccessTokenExpired() {
        Date now = new Date();
        return now.getTime() / 1000L - this.updateTime.getTime() / 1000L > (long)(this.expiresIn * 2 / 3);
    }

    public void setFuncsByList(List<Integer> funcsList) {
        if (funcsList != null && !funcsList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Integer id : funcsList) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(id);
            }
            this.funcs = sb.toString();
        }
    }

    public boolean hasFunc(Integer func) {
        if (func == null || StringUtils.isBlank((CharSequence)this.funcs)) {
            return false;
        }
        return String.format(",%s,", this.funcs).contains(String.format(",%s,", func));
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public Integer getId() {
        return this.id;
    }

    public Integer getOrgId() {
        return this.orgId;
    }

    public String getAuthorizerAppId() {
        return this.authorizerAppId;
    }

    public String getAuthorizerAccessToken() {
        return this.authorizerAccessToken;
    }

    public String getAuthorizerRefershToken() {
        return this.authorizerRefershToken;
    }

    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    public String getFuncs() {
        return this.funcs;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setOrgId(Integer orgId) {
        this.orgId = orgId;
    }

    public void setAuthorizerAppId(String authorizerAppId) {
        this.authorizerAppId = authorizerAppId;
    }

    public void setAuthorizerAccessToken(String authorizerAccessToken) {
        this.authorizerAccessToken = authorizerAccessToken;
    }

    public void setAuthorizerRefershToken(String authorizerRefershToken) {
        this.authorizerRefershToken = authorizerRefershToken;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    public void setFuncs(String funcs) {
        this.funcs = funcs;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }
}

