/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.push.constant;

import com.baijia.tianxiao.dal.push.constant.MsgUserRole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum MsgUserType {
    STUDENT(1, "\u5b66\u751f"),
    ORG(2, "\u673a\u6784"),
    SYSTEM(3, "\u7cfb\u7edf"),
    UNKNOWN(4, "\u672a\u77e5");

    private static final Logger log;
    private int value;
    private String desc;

    private MsgUserType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    public static MsgUserType getUserType(MsgUserRole role) {
        if (role != null && MsgUserRole.isStu(role.getValue())) {
            return STUDENT;
        }
        if (role != null && MsgUserRole.isOrg(role.getValue())) {
            return ORG;
        }
        if (role != null && MsgUserRole.SYSTEM.getValue() == role.getValue()) {
            return SYSTEM;
        }
        log.warn("MsgUserRole is error." + (Object)((Object)role));
        return UNKNOWN;
    }

    public static MsgUserType getUserType(int userRole) {
        MsgUserRole role = MsgUserRole.getByCode(userRole);
        return MsgUserType.getUserType(role);
    }

    static {
        log = LoggerFactory.getLogger(MsgUserType.class);
    }
}

