/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.constant.TXCascadeAccountStatus;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

@Repository
public class TxCascadeAccountDaoImpl
extends JdbcTemplateDaoSupport<TXCascadeAccount>
implements TXCascadeAccountDao {
    public TxCascadeAccountDaoImpl() {
        super(TXCascadeAccount.class);
    }

    @Override
    public Integer getCountByOrgId(Integer orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public TXCascadeAccount getByIdAndOrgId(Integer id, Integer orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("id", (Serializable)id);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.eq("status", (Serializable)TXCascadeAccountStatus.VALID.getCode());
        return (TXCascadeAccount)((Object)this.uniqueResult(builder));
    }

    @Override
    public List<TXCascadeAccount> getByOrgIds(List<Integer> orgIds, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("orgId", orgIds);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.desc("createTime");
        if (pageDto != null) {
            builder.setPage(pageDto);
        }
        return this.queryList(builder);
    }

    @Override
    public Integer getCountByOrgIds(List<Integer> orgIds) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.in("orgId", orgIds);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.eq("status", (Serializable)TXCascadeAccountStatus.VALID.getCode());
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public Integer getCountByOrgIds(List<Integer> orgIds, Integer status) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.in("orgId", orgIds);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public List<TXCascadeAccount> getByCIdAndOrgId(Integer orgId, Integer credentialId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("credentialId", (Serializable)credentialId);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public List<TXCascadeAccount> getTXCascadeAccountListByOrgId(Long orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("status", (Serializable)TXCascadeAccountStatus.VALID.getCode());
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public List<Integer> listIdByAccountType(Integer orgId, Integer accountType) {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT id FROM yunying.tx_cascade_account WHERE 1=1");
        if (orgId != null) {
            builder.append(" AND org_id=").append(orgId);
        }
        if (accountType != null) {
            builder.append(" AND account_type=").append(accountType);
        }
        return (List)this.getNamedJdbcTemplate().query(builder.toString(), (ResultSetExtractor)new ResultSetExtractor<List<Integer>>(){

            public List<Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                ArrayList<Integer> appIds = new ArrayList<Integer>();
                while (rs.next()) {
                    Integer appId = rs.getInt("id");
                    appIds.add(appId);
                }
                return appIds;
            }
        });
    }

    @Override
    public TXCascadeAccount getByCredentialIdAndOrgId(Integer orgId, Integer credentialId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("credentialId", (Serializable)credentialId);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return (TXCascadeAccount)((Object)this.uniqueResult(builder));
    }

    @Override
    public List<TXCascadeAccount> getTXCascadeAccountListByOrgId(Long orgId, Integer status) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        return this.queryList(builder);
    }

    @Override
    public List<TXCascadeAccount> getTXCascadeAccountListByStatusAndOrgId(Integer cascadeId, int status, Integer orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        if (GenericsUtils.notNullAndEmpty((Object)cascadeId)) {
            builder.ne("id", (Serializable)cascadeId);
        }
        builder.eq("status", (Serializable)Integer.valueOf(status));
        return this.queryList(builder);
    }
}

