/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.constant.OrgTeacherStatus;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherDao;
import com.baijia.tianxiao.dal.org.po.OrgTeacher;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class OrgTeacherDaoImpl
extends JdbcTemplateDaoSupport<OrgTeacher>
implements OrgTeacherDao {
    private static final Logger log = LoggerFactory.getLogger(OrgTeacherDaoImpl.class);

    public OrgTeacherDaoImpl() {
        super(OrgTeacher.class);
    }

    @Override
    public List<Long> getTeacherIds(Long orgId, Integer status) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"userId"});
        builder.eq("orgId", (Serializable)orgId);
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        return this.queryForList(builder, Long.class);
    }

    @Override
    public List<OrgTeacher> listByLastId(Long orgId, Long lastId, Integer pageSize, Integer status, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        if (lastId != null & lastId != 0L) {
            builder.lt("id", (Serializable)lastId);
        }
        builder.eq("orgId", (Serializable)orgId);
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        builder.setMaxSize(pageSize);
        builder.desc("id");
        log.debug("list by last id sql = {},params = {}", (Object)builder.toSql(), (Object)builder);
        return this.queryList(builder);
    }

    @Override
    public List<OrgTeacher> getTeacherByOpenIdAndOrgId(Long orgId, String weixinOpenId, Integer status, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("weixin", (Serializable)((Object)weixinOpenId));
        builder.eq("orgId", (Serializable)orgId);
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        builder.desc("id");
        return this.queryList(builder);
    }

    @Override
    public List<OrgTeacher> getTeacherByMobileAndOrgId(Long orgId, String mobile, Integer maxSize, String ... queryProps) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mobile}), (Object)"mobile can not be empty!");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("mobile", (Serializable)((Object)mobile));
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("status", (Serializable)Integer.valueOf(OrgTeacherStatus.SIGNED.getCode()));
        builder.desc("id");
        if (maxSize != null && maxSize > 0) {
            builder.setMaxSize(maxSize);
        }
        log.debug("sql={},param={}", (Object)builder.toSql(), (Object)builder.collectConditionValue());
        return this.queryList(builder);
    }

    @Override
    public List<OrgTeacher> getTeacherByUserIdAndOrgId(Long orgId, Long userId, Integer status, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("userId", (Serializable)userId);
        builder.eq("orgId", (Serializable)orgId);
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        builder.desc("id");
        return this.queryList(builder);
    }

    @Override
    public List<OrgTeacher> getTeacherByUserIdsAndOrgId(Long orgId, Collection<Long> userIds, Integer status, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.in("userId", userIds);
        builder.eq("orgId", (Serializable)orgId);
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        builder.desc("id");
        return this.queryList(builder);
    }

    @Override
    public Map<Long, OrgTeacher> getMapByIds(Long orgId, Collection<Long> userIds, String ... queryProps) {
        if (userIds.isEmpty()) {
            return Collections.emptyMap();
        }
        List<OrgTeacher> orgTeachers = this.getTeacherByUserIdsAndOrgId(orgId, userIds, OrgTeacherStatus.SIGNED.getCode(), queryProps);
        if (CollectionUtils.isEmpty(orgTeachers)) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMap();
        for (OrgTeacher user : orgTeachers) {
            result.put(Long.valueOf(user.getUserId()), user);
        }
        return result;
    }

    @Override
    public void refreshOrgTeacher(Long orgId, Long id) {
        StringBuilder sb = new StringBuilder("update yunying.org_teachers set status =2 where id > :id and  org_id = :orgId");
        HashMap param = Maps.newHashMap();
        param.put("orgId", orgId);
        param.put("id", id);
        this.getNamedJdbcTemplate().update(sb.toString(), (Map)param);
    }

    @Override
    public List<OrgTeacher> getTeachersByOrgId(Long orgId, PageDto page, String ... queryProp) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.select(queryProp);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("status", (Serializable)Integer.valueOf(OrgTeacherStatus.SIGNED.getCode()));
        builder.desc("id");
        builder.setPage(page);
        return this.queryList(builder);
    }
}

