/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.commons.OrgStatisticsExtractor;
import com.baijia.tianxiao.dal.org.dao.OrgGroupMsgDao;
import com.baijia.tianxiao.dal.org.po.OrgGroupMsg;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

@Repository
public class OrgGroupMsgDaoImpl
extends JdbcTemplateDaoSupport<OrgGroupMsg>
implements OrgGroupMsgDao {
    public OrgGroupMsgDaoImpl() {
        super(OrgGroupMsg.class);
    }

    @Override
    public List<OrgGroupMsg> getByOrgId(Long orgId, PageDto page, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        builder.setPage(page);
        builder.desc("createTime");
        return this.queryList(builder);
    }

    @Override
    public Map<Long, Integer> getOrgGroupMsgTotal(Date startDate, Date endDate, List<Long> TianxiaoOrgIds) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql = "select count(1) as count,org_id from yunying.org_group_msg where org_id in (:orgIds) ";
        if (startDate != null) {
            sql = sql + " and create_time between :startDate and :endDate";
            param.put("startDate", startDate);
            param.put("endDate", endDate);
        }
        sql = sql + " GROUP BY org_id";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new OrgStatisticsExtractor());
    }

    @Override
    public Map<Long, List<OrgGroupMsg>> getOrgGroupMsgMap(Date startDate, Date endDate, List<Long> TianxiaoOrgIds) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql = "select * from yunying.org_group_msg where org_id in (:orgIds) ";
        if (startDate != null) {
            sql = sql + " and create_time between :startDate and :endDate";
            param.put("startDate", startDate);
            param.put("endDate", endDate);
        }
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, List<OrgGroupMsg>>>(){

            public Map<Long, List<OrgGroupMsg>> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, List<OrgGroupMsg>> map = new HashMap<Long, List<OrgGroupMsg>>();
                while (rs.next()) {
                    Long orgId = rs.getLong("org_id");
                    ArrayList<OrgGroupMsg> list = (ArrayList<OrgGroupMsg>)map.get(orgId);
                    OrgGroupMsg orgGroupMsg = new OrgGroupMsg();
                    orgGroupMsg.setId(rs.getLong("id"));
                    orgGroupMsg.setOrgId(rs.getLong("org_id"));
                    orgGroupMsg.setSubject(rs.getString("subject"));
                    orgGroupMsg.setCreateTime(rs.getDate("create_time"));
                    if (list == null) {
                        list = new ArrayList<OrgGroupMsg>();
                        map.put(orgId, list);
                    }
                    list.add(orgGroupMsg);
                }
                return map;
            }
        });
    }
}

