/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.advisory.dao.impl;

import com.baijia.tianxiao.dal.advisory.dao.OrgStudentAdvisoryDao;
import com.baijia.tianxiao.dal.advisory.po.OrgStudentAdvisory;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.sqlbuilder.util.Expressions;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class OrgStudentAdvisoryDaoImpl
extends JdbcTemplateDaoSupport<OrgStudentAdvisory>
implements OrgStudentAdvisoryDao {
    private static final Logger log = LoggerFactory.getLogger(OrgStudentAdvisoryDaoImpl.class);

    public OrgStudentAdvisoryDaoImpl() {
        super(OrgStudentAdvisory.class);
    }

    @Override
    public List<OrgStudentAdvisory> query(Date startTime, Date endTime, Collection<Long> orgIds, Integer advisoryType, String contenType, Collection<Integer> statuses, Collection<Long> studentIds, Collection<Integer> courseIds, PageDto page) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (startTime != null && endTime != null) {
            builder.between("createTime", (Comparable)startTime, (Comparable)endTime);
        }
        if (CollectionUtils.isNotEmpty(orgIds)) {
            builder.in("orgId", orgIds);
        }
        if (advisoryType != null) {
            if (advisoryType == 1) {
                builder.eq("advisoryType", (Serializable)advisoryType);
            } else if (advisoryType == 0) {
                builder.eq("advisoryType", (Serializable)advisoryType);
                builder.eq("contentType", (Serializable)((Object)contenType));
            } else {
                builder.eq("contentType", (Serializable)((Object)contenType));
            }
        }
        if (CollectionUtils.isNotEmpty(statuses)) {
            builder.in("status", statuses);
        }
        if (CollectionUtils.isNotEmpty(studentIds)) {
            if (CollectionUtils.isNotEmpty(courseIds)) {
                builder.or(Expressions.in((String)"studentId", studentIds), Expressions.in((String)"courseId", courseIds));
            } else {
                builder.in("studentId", studentIds);
            }
        } else if (CollectionUtils.isNotEmpty(courseIds)) {
            builder.in("courseId", courseIds);
        }
        builder.gt("status", (Serializable)Integer.valueOf(0));
        builder.desc("createTime");
        builder.setPage(page);
        return this.queryList(builder);
    }

    @Override
    public OrgStudentAdvisory getByCallId(Long callId) {
        Preconditions.checkNotNull((Object)callId, (Object)"callId is null");
        Preconditions.checkArgument((callId > 0L ? 1 : 0) != 0, (Object)("call id is illegal:" + callId));
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("callId", (Serializable)callId);
        return (OrgStudentAdvisory)this.uniqueResult(builder);
    }

    @Override
    public void updateStatusByCallId(Long callId, int status) {
    }

    @Override
    public List<Long> getOrgIds(Date startTime, Date endTime) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"orgId"});
        if (startTime != null && endTime != null) {
            builder.select("orgId");
            builder.between("createTime", (Comparable)startTime, (Comparable)endTime);
            return this.queryForList(builder, Long.class);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<Long> query(Date startTime, Date endTime, Integer areaId, String key) {
        HashMap map = Maps.newHashMap();
        StringBuilder builder = new StringBuilder();
        builder.append("select advisory.id from yunying.org_student_advisory advisory ");
        builder.append("inner join yunying.org_info info on advisory.org_id = info.org_id ");
        if (StringUtils.isNotEmpty((CharSequence)key)) {
            builder.append("inner join cdb.org_course course on advisory.course_id = course.id ");
            builder.append("left join cdb.student student on advisory.student_id = student.user_id ");
            builder.append("left join cdb.user user on advisory.student_id = user.id ");
        }
        builder.append("where advisory.create_time between :startTime and :endTime ");
        if (areaId != null) {
            builder.append("and info.area_id =:areaId ");
            map.put("areaId", areaId);
        }
        if (StringUtils.isNotEmpty((CharSequence)key)) {
            builder.append("and (info.shortname like :name or course.name like :name or student.realname like :name or student.nickname like :name or user.mobile like :name)");
            map.put("name", key + "%");
        }
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        log.debug(builder.toString());
        List result = this.getNamedJdbcTemplate().queryForList(builder.toString(), (Map)map, Long.class);
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            return result;
        }
        return Lists.newArrayList();
    }

    @Override
    public List<OrgStudentAdvisory> query(Collection<Long> ids, PageDto pageDto, String ... querPros) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(querPros);
        builder.in("id", ids);
        builder.setPage(pageDto);
        builder.desc("create_time");
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudentAdvisory> queryUnLogin(Date startTime, Date endTime, Collection<Long> orgIds, Integer advisoryType, String contenType, Collection<Integer> statuses, String searchKey, Collection<Integer> courseIds, PageDto page) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (startTime != null && endTime != null) {
            builder.between("createTime", (Comparable)startTime, (Comparable)endTime);
        }
        if (CollectionUtils.isNotEmpty(orgIds)) {
            builder.in("orgId", orgIds);
        }
        if (advisoryType != null) {
            if (advisoryType == 1) {
                builder.eq("advisoryType", (Serializable)advisoryType);
            } else if (advisoryType == 0) {
                builder.eq("advisoryType", (Serializable)advisoryType);
                builder.eq("contentType", (Serializable)((Object)contenType));
            } else {
                builder.eq("contentType", (Serializable)((Object)contenType));
            }
        }
        if (CollectionUtils.isNotEmpty(statuses)) {
            builder.in("status", statuses);
        }
        if (StringUtils.isNotEmpty((CharSequence)searchKey)) {
            if (CollectionUtils.isNotEmpty(courseIds)) {
                builder.or(Expressions.in((String)"courseId", courseIds), Expressions.like((String)"mobile", (Serializable)((Object)searchKey), (MatchMode)MatchMode.ANYWHERE));
            } else {
                builder.like("mobile", (Serializable)((Object)searchKey), MatchMode.ANYWHERE);
            }
        }
        builder.eq("studentId", (Serializable)Integer.valueOf(0));
        builder.gt("status", (Serializable)Integer.valueOf(0));
        builder.desc("createTime");
        builder.setPage(page);
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudentAdvisory> getAdvisoryListByMinId(Long minId, Date lastDate, int maxSize, String ... queryProps) {
        Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0, (Object)"maxSize is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        if (minId == null || minId == 0L) {
            if (lastDate == null) {
                throw new IllegalArgumentException("must have minId or lastDate");
            }
            builder.gt("createTime", (Serializable)lastDate);
        } else {
            builder.gt("id", (Serializable)minId);
        }
        builder.asc("createTime");
        builder.setMaxSize(Integer.valueOf(maxSize));
        return this.queryList(builder);
    }

    @Override
    public int getPeroidTeacherCourseAdvisory(Long courseId, Date startDate, Date endDate) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("courseId", (Serializable)courseId);
        builder.eq("contentType", (Serializable)((Object)"cdb.teacher_class_course"));
        builder.ge("createTime", (Serializable)startDate);
        builder.le("createTime", (Serializable)endDate);
        Integer count = (Integer)this.queryForObject(builder, Integer.class);
        if (count == null) {
            return 0;
        }
        return count;
    }

    @Override
    public int getTotalTeacherCourseAdvisory(Long courseId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("courseId", (Serializable)courseId);
        builder.eq("contentType", (Serializable)((Object)"cdb.teacher_class_course"));
        Integer count = (Integer)this.queryForObject(builder, Integer.class);
        if (count == null) {
            return 0;
        }
        return count;
    }

    @Override
    public int getPeroidOrgCourseAdvisory(Long courseId, Date startDate, Date endDate) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("courseId", (Serializable)courseId);
        builder.eq("contentType", (Serializable)((Object)"cdb.org_course"));
        builder.ge("createTime", (Serializable)startDate);
        builder.le("createTime", (Serializable)endDate);
        Integer count = (Integer)this.queryForObject(builder, Integer.class);
        if (count == null) {
            return 0;
        }
        return count;
    }

    @Override
    public int getTotalOrgCourseAdvisory(Long courseId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("courseId", (Serializable)courseId);
        builder.eq("contentType", (Serializable)((Object)"cdb.org_course"));
        Integer count = (Integer)this.queryForObject(builder, Integer.class);
        if (count == null) {
            return 0;
        }
        return count;
    }
}

