/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.activity.dao.referral.impl;

import com.baijia.tianxiao.dal.activity.dao.referral.ReferralRecordDao;
import com.baijia.tianxiao.dal.activity.dto.PageInfo;
import com.baijia.tianxiao.dal.activity.po.referral.ReferralRecord;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class ReferralRecordDaoImpl
extends JdbcTemplateDaoSupport<ReferralRecord>
implements ReferralRecordDao {
    private static final Logger log = LoggerFactory.getLogger(ReferralRecordDaoImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(ReferralRecordDaoImpl.class);

    public ReferralRecordDaoImpl() {
        super(ReferralRecord.class);
    }

    @Override
    public ReferralRecord selectRecordById(long id) {
        return (ReferralRecord)this.getById(Long.valueOf(id), new String[0]);
    }

    @Override
    public void updateReferralRecord(ReferralRecord record) {
        this.update(record, new String[0]);
    }

    @Override
    public void addReferralRecord(ReferralRecord record) {
        this.save(record, new String[0]);
    }

    @Override
    public ReferralRecord selectByReferralPhone(String phone) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("referralPhone", (Serializable)((Object)phone));
        List records = this.queryList(builder);
        if (records != null && records.size() > 0) {
            return (ReferralRecord)records.get(0);
        }
        return null;
    }

    @Override
    public List<ReferralRecord> selectRecordsByPage(long activityId, PageInfo pageInfo) {
        HashMap<String, Number> paramMap = new HashMap<String, Number>();
        paramMap.put("activityId", activityId);
        String sql = null;
        if (pageInfo == null) {
            sql = "select * from yunying.tx_activity_referral_record where activity_id = :activityId order by id desc ";
        } else {
            paramMap.put("firstIndex", (pageInfo.getPageDto().getPageNum() - 1) * pageInfo.getPageDto().getPageSize());
            paramMap.put("pageSize", pageInfo.getPageDto().getPageSize());
            if (pageInfo.getLastId() == null || pageInfo.getLastId() == 0L) {
                sql = "select * from yunying.tx_activity_referral_record where activity_id = :activityId order by id desc limit :firstIndex,:pageSize ";
            } else {
                sql = "select * from yunying.tx_activity_referral_record where activity_id = :activityId  and id<:id order by id desc limit :firstIndex,:pageSize";
                paramMap.put("id", pageInfo.getLastId());
            }
        }
        return this.getNamedJdbcTemplate().query(sql, paramMap, (RowMapper)new BeanPropertyRowMapper(ReferralRecord.class));
    }

    @Override
    public int selectCountByBrokerAndTime(Long activityId, String phone, Date startTime, Date endTime) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("activityId", (Serializable)activityId);
        builder.count("id");
        builder.eq("brokerPhone", (Serializable)((Object)phone));
        builder.between("createTime", (Comparable)startTime, (Comparable)endTime);
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public List<ReferralRecord> selectRecordsByTime(Long activityId, Date startTime, Date endTime) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("activity_id", (Serializable)activityId);
        builder.between("markTime", (Comparable)startTime, (Comparable)endTime);
        List records = this.queryList(builder);
        if (records != null) {
            return records;
        }
        return Collections.emptyList();
    }

    @Override
    public List<ReferralRecord> selectBrokersByActivityId(long activityId, PageInfo pageInfo) {
        HashMap<String, Number> paramMap = new HashMap<String, Number>();
        paramMap.put("activityId", activityId);
        String sql = null;
        if (pageInfo == null) {
            sql = " select * from (select max(id) as id  from yunying.tx_activity_referral_record where activity_Id =:activityId group by broker_phone ) as tmp , yunying.tx_activity_referral_record as raw where raw.id = tmp.id  order by raw.id desc ";
        } else {
            paramMap.put("id", pageInfo.getLastId());
            paramMap.put("firstIndex", (pageInfo.getPageDto().getPageNum() - 1) * pageInfo.getPageDto().getPageSize());
            paramMap.put("pageSize", pageInfo.getPageDto().getPageSize());
            if (pageInfo.getLastId() == null || pageInfo.getLastId() == 0L) {
                sql = "select * from (select max(id) as id  from yunying.tx_activity_referral_record  where activity_id =:activityId group by broker_phone limit :firstIndex,:pageSize) as tmp , yunying.tx_activity_referral_record as raw where raw.id = tmp.id  order by raw.id desc ";
                paramMap.remove("id");
            } else {
                sql = " select * from (select max(id) as id  from yunying.tx_activity_referral_record where activity_Id =:activityId group by broker_phone having max(id) < :id   limit :firstIndex,:pageSize) as tmp , yunying.tx_activity_referral_record as raw where raw.id = tmp.id  order by raw.id desc ";
            }
        }
        return (List)this.getNamedJdbcTemplate().query(sql, paramMap, (ResultSetExtractor)new ResultSetExtractor<List<ReferralRecord>>(){

            public List<ReferralRecord> extractData(ResultSet rs) throws SQLException, DataAccessException {
                ArrayList<ReferralRecord> brokers = new ArrayList<ReferralRecord>();
                while (rs.next()) {
                    brokers.add(this.toActivity(rs));
                }
                return brokers;
            }

            private ReferralRecord toActivity(ResultSet rs) throws SQLException {
                ReferralRecord broker = new ReferralRecord();
                broker.setId(rs.getLong("id"));
                broker.setActivityId(rs.getLong("activity_id"));
                broker.setCreateTime(rs.getTimestamp("create_time"));
                broker.setUpdateTime(rs.getTimestamp("update_time"));
                broker.setMarkTime(rs.getTimestamp("mark_time"));
                broker.setAccountType(rs.getInt("account_type"));
                broker.setAccountNum(rs.getString("account_num"));
                broker.setBrokerName(rs.getString("broker_name"));
                broker.setBrokerPhone(rs.getString("broker_phone"));
                broker.setReferralName(rs.getString("referral_name"));
                broker.setReferralPhone(rs.getString("referral_phone"));
                broker.setReferralDesc(rs.getString("referral_desc"));
                broker.setGiftId(rs.getLong("gift_id"));
                broker.setIntroduceWayDesc(rs.getString("introduce_way_desc"));
                broker.setType(rs.getInt("type"));
                broker.setGiftDesc(rs.getString("gift_desc"));
                broker.setSettlementStatus(rs.getInt("settlement_status"));
                return broker;
            }
        });
    }

    @Override
    public Map<Long, Integer> listReferrals(List<Long> activityId) {
        HashMap<String, List<Long>> paramMap = new HashMap<String, List<Long>>();
        String sql = "select activity_id , count(*) count from (select activity_id , count(*) from yunying.tx_activity_referral_record where activity_id in (:activityIds) group by activity_id , referral_phone ) as result group by activity_id ";
        paramMap.put("activityIds", activityId);
        return (Map)this.getNamedJdbcTemplate().query(sql, paramMap, (ResultSetExtractor)new ResultSetExtractor<Map<Long, Integer>>(){

            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, Integer> statistics = new HashMap<Long, Integer>();
                while (rs.next()) {
                    Long activityId = rs.getLong("activity_id");
                    Integer count = rs.getInt("count");
                    statistics.put(activityId, count);
                }
                return statistics;
            }
        });
    }

    @Override
    public Map<Long, Integer> listBrokerCount(List<Long> activityId) {
        HashMap<String, List<Long>> paramMap = new HashMap<String, List<Long>>();
        String sql = "select activity_id , count(*) count from (select activity_id , count(*) from yunying.tx_activity_referral_record where activity_id in (:activityIds) group by activity_id , broker_phone ) as result group by activity_id ";
        paramMap.put("activityIds", activityId);
        return (Map)this.getNamedJdbcTemplate().query(sql, paramMap, (ResultSetExtractor)new ResultSetExtractor<Map<Long, Integer>>(){

            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, Integer> statistics = new HashMap<Long, Integer>();
                while (rs.next()) {
                    Long activityId = rs.getLong("activity_id");
                    Integer count = rs.getInt("count");
                    statistics.put(activityId, count);
                }
                return statistics;
            }
        });
    }

    @Override
    public Map<Long, Integer> listToPayCount(List<Long> activityId) {
        HashMap<String, List<Long>> paramMap = new HashMap<String, List<Long>>();
        String sql = "select id, activity_id , gift_desc from yunying.tx_activity_referral_record where activity_id in (:activityIds)  and  settlement_status = 2 and mark_time is not null ";
        paramMap.put("activityIds", activityId);
        return (Map)this.getNamedJdbcTemplate().query(sql, paramMap, (ResultSetExtractor)new ResultSetExtractor<Map<Long, Integer>>(){

            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, Integer> statistics = new HashMap<Long, Integer>();
                while (rs.next()) {
                    Long activityId = rs.getLong("activity_id");
                    Integer count = (Integer)statistics.get(activityId);
                    if (count == null) {
                        count = 0;
                    }
                    count = count + 1;
                    statistics.put(activityId, count);
                }
                return statistics;
            }
        });
    }

    @Override
    public List<ReferralRecord> selectBrokersByTime(long activityId, String brokerPhone, int status, Date startTime, Date endTime) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("activityId", activityId);
        paramMap.put("status", status);
        paramMap.put("startTime", startTime);
        paramMap.put("endTime", endTime);
        String sql = "select * from yunying.tx_activity_referral_record where activity_id=:activityId and settlement_status=:status and mark_time >= :startTime and mark_time < :endTime";
        if (GenericsUtils.notNullAndEmpty((Object)brokerPhone)) {
            sql = sql + " and broker_phone = :brokerPhone";
            paramMap.put("brokerPhone", brokerPhone);
        }
        return this.getNamedJdbcTemplate().query(sql, paramMap, (RowMapper)new BeanPropertyRowMapper(ReferralRecord.class));
    }

    @Override
    public List<ReferralRecord> selectReferralRecordDetail(long activityId, String brokerPhone, Integer status, Date startTime, Date endTime, PageInfo pageInfo) {
        Long lastId = pageInfo.getLastId();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        String sql = "select * from yunying.tx_activity_referral_record where   activity_id = :activityId and settlement_status=:status and broker_phone=:brokerPhone  and mark_time >= :startTime and mark_time < :endTime ";
        if (lastId != null && lastId != 0L) {
            sql = sql + " and id < :lastId ";
            paramMap.put("lastId", lastId);
        }
        sql = sql + " order by id desc limit :firstIndex,:pageSize";
        paramMap.put("firstIndex", (pageInfo.getPageDto().getPageNum() - 1) * pageInfo.getPageDto().getPageSize());
        paramMap.put("pageSize", pageInfo.getPageDto().getPageSize());
        paramMap.put("activityId", activityId);
        paramMap.put("status", status);
        paramMap.put("startTime", startTime);
        paramMap.put("endTime", endTime);
        paramMap.put("brokerPhone", brokerPhone);
        return this.getNamedJdbcTemplate().query(sql, paramMap, (RowMapper)new BeanPropertyRowMapper(ReferralRecord.class));
    }

    @Override
    public Integer getReferralTotal(List<Long> activityIds, Date startTime, Date endTime) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (activityIds == null || activityIds.size() < 1) {
            return 0;
        }
        String sql = "select count(*) from yunying.tx_activity_referral_record where activity_id in (:activityIds)";
        if (startTime != null && endTime != null) {
            sql = sql + " AND create_time between :startDate and :endDate";
            param.put("startDate", startTime);
            param.put("endDate", endTime);
        }
        param.put("activityIds", activityIds);
        return this.getNamedJdbcTemplate().queryForInt(sql, param);
    }

    @Override
    public Integer getBrokerTotal(List<Long> activityIds, Date startTime, Date endTime) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        String sql = "select count(DISTINCT broker_phone) count from yunying.tx_activity_referral_record where activity_id in (:activityIds)";
        if (startTime != null && endTime != null) {
            sql = sql + " and create_time between :startTime and :endDate";
            param.put("startTime", startTime);
            param.put("endDate", endTime);
        }
        param.put("activityIds", activityIds);
        return (Integer)this.getNamedJdbcTemplate().queryForObject(sql, param, Integer.class);
    }
}

