/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.activity.dao.impl;

import com.baijia.tianxiao.dal.activity.dao.EnrollDao;
import com.baijia.tianxiao.dal.activity.dto.PageInfo;
import com.baijia.tianxiao.dal.activity.po.ActivityEnroll;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class EnrollDaoImpl
extends JdbcTemplateDaoSupport<ActivityEnroll>
implements EnrollDao {
    private static final Logger logger = LoggerFactory.getLogger(EnrollDaoImpl.class);

    public EnrollDaoImpl() {
        super(ActivityEnroll.class);
    }

    @Override
    public List<ActivityEnroll> selectEnrollsByActivityId(long activityId, PageInfo page) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("activityId", (Serializable)Long.valueOf(activityId));
        builder.eq("status", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        if (page != null) {
            if (page.getLastId() != null && page.getLastId() > 0L) {
                builder.lt("id", (Serializable)page.getLastId());
            }
            builder.setPage(page.getPageDto());
        }
        builder.desc("id");
        return this.queryList(builder);
    }

    @Override
    public void insertEnroll(ActivityEnroll enroll) {
        this.save(enroll, new String[0]);
    }

    @Override
    public int getEnrollCount(long activityId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("activityId", (Serializable)Long.valueOf(activityId));
        builder.count("id");
        builder.eq("status", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public ActivityEnroll selectEnrollByMobile(long activityId, String mobile) {
        if (NumberUtils.isDigits((String)mobile)) {
            SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
            builder.eq("activityId", (Serializable)Long.valueOf(activityId));
            builder.like("content", (Serializable)((Object)("\"mobile\":\"" + mobile + "\"")), MatchMode.ANYWHERE);
            List enrolls = this.queryList(builder);
            if (enrolls != null && enrolls.size() > 0) {
                return (ActivityEnroll)enrolls.get(0);
            }
        } else {
            logger.warn("[ActivityEnroll] mobile=" + mobile);
            throw new RuntimeException("\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef");
        }
        return null;
    }

    @Override
    public Integer getEnrollTotal(List<Long> activityIds, Date startDate, Date endDate) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("activityId", activityIds);
        builder.eq("status", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        if (startDate != null) {
            builder.between("createTime", (Comparable)startDate, (Comparable)endDate);
        }
        builder.count("id");
        return (Integer)this.queryForObject(builder, Integer.class);
    }
}

