/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.wechat.po;

import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

@Entity
@Table(name="org_wechat_fans", catalog="yunying")
public class Fans {
    @Id
    @GeneratedValue
    private Integer id;
    @Column(name="authorizer_app_id")
    private String authorizerAppId;
    @Column(name="open_id")
    private String openId;
    @Column(name="subscribe")
    private Integer subscribe;
    @Column(name="last_communication_time")
    private Date lastCommunicationTime;
    @Column(name="nick")
    private String nick;
    @Column(name="remark")
    private String remark;
    @Column(name="head_img_url")
    private String headImgUrl;
    @Column(name="sex")
    private Integer sex;
    @Column(name="language")
    private String language;
    @Column(name="city")
    private String city;
    @Column(name="province")
    private String province;
    @Column(name="country")
    private String country;
    @Column(name="subscribe_time")
    private Date subscribeTime;
    @Column(name="groug_id")
    private Integer groupId;
    @Column(name="create_time")
    private Date createTime;
    @Column(name="update_time")
    private Date updateTime;
    @Column(name="is_del")
    private Integer isDel;

    public void initBasicAttribute() {
        Date now;
        this.createTime = now = new Date();
        this.updateTime = now;
        this.isDel = DeleteStatus.NORMAL.getValue();
        if (this.groupId == null) {
            this.groupId = -1;
        }
        if (this.remark == null) {
            this.remark = "";
        }
        if (this.language == null) {
            this.language = "";
        }
        if (this.subscribe == null) {
            this.subscribe = 0;
            this.subscribeTime = new Date(0L);
        }
        this.lastCommunicationTime = this.subscribeTime;
    }

    public String getShowName() {
        if (StringUtils.isNotBlank((CharSequence)this.remark)) {
            return this.remark;
        }
        return this.nick;
    }

    public boolean isAllowToChat() {
        Date now;
        long diff;
        return this.lastCommunicationTime != null && (diff = (now = new Date()).getTime() / 1000L - this.lastCommunicationTime.getTime() / 1000L) >= 0L && diff < 172800L;
    }

    public void refreshBy(Fans newFans) {
        this.setCity(newFans.getCity());
        this.setCountry(newFans.getCountry());
        this.setGroupId(newFans.getGroupId());
        this.setHeadImgUrl(newFans.getHeadImgUrl());
        this.setLanguage(newFans.getLanguage());
        this.setNick(newFans.getNick());
        this.setProvince(newFans.getProvince());
        this.setRemark(newFans.getRemark());
        this.setSex(newFans.getSex());
        this.setSubscribeTime(newFans.getSubscribeTime());
        this.setSubscribe(newFans.getSubscribe());
        this.setUpdateTime(new Date());
    }

    public boolean isSubscribed() {
        return this.subscribe != null && this.subscribe.equals(1);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public Integer getId() {
        return this.id;
    }

    public String getAuthorizerAppId() {
        return this.authorizerAppId;
    }

    public String getOpenId() {
        return this.openId;
    }

    public Integer getSubscribe() {
        return this.subscribe;
    }

    public Date getLastCommunicationTime() {
        return this.lastCommunicationTime;
    }

    public String getNick() {
        return this.nick;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getHeadImgUrl() {
        return this.headImgUrl;
    }

    public Integer getSex() {
        return this.sex;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getCity() {
        return this.city;
    }

    public String getProvince() {
        return this.province;
    }

    public String getCountry() {
        return this.country;
    }

    public Date getSubscribeTime() {
        return this.subscribeTime;
    }

    public Integer getGroupId() {
        return this.groupId;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public Integer getIsDel() {
        return this.isDel;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setAuthorizerAppId(String authorizerAppId) {
        this.authorizerAppId = authorizerAppId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public void setSubscribe(Integer subscribe) {
        this.subscribe = subscribe;
    }

    public void setLastCommunicationTime(Date lastCommunicationTime) {
        this.lastCommunicationTime = lastCommunicationTime;
    }

    public void setNick(String nick) {
        this.nick = nick;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setHeadImgUrl(String headImgUrl) {
        this.headImgUrl = headImgUrl;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public void setSubscribeTime(Date subscribeTime) {
        this.subscribeTime = subscribeTime;
    }

    public void setGroupId(Integer groupId) {
        this.groupId = groupId;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public void setIsDel(Integer isDel) {
        this.isDel = isDel;
    }
}

