/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.push.dao.impl;

import com.baijia.tianxiao.dal.push.constant.MsgUserRole;
import com.baijia.tianxiao.dal.push.dao.MessageDao;
import com.baijia.tianxiao.dal.push.dto.ConsultMessageDto;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.push.po.UserIdentify;
import com.baijia.tianxiao.dal.push.utils.DbParamBuilder;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class MessageDaoImpl
extends JdbcTemplateDaoSupport<ConsultMessage>
implements MessageDao {
    private static final Logger log = LoggerFactory.getLogger(MessageDaoImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(MessageDaoImpl.class);

    public MessageDaoImpl() {
        super(ConsultMessage.class);
    }

    @Override
    public void batchInsertMessage(List<ConsultMessage> messages) {
    }

    @Override
    public List<ConsultMessage> selectNewOrgRecordList(long orgNumber, Integer cascadeId, long msgId, int limit) {
        StringBuilder sql = new StringBuilder();
        sql.append("select * from yunying.tx_message_record where receiver_id = :cascadeId AND id > :msgId ");
        sql.append("union ALL select * from yunying.tx_message_record where sender_id = :cascadeId AND id > :msgId ");
        sql.append("order by id desc limit :limit");
        Map<String, Object> param = DbParamBuilder.getInstance().add("msgId", msgId).add("limit", limit).build();
        if (cascadeId != null && cascadeId > 0) {
            param.put("cascadeId", cascadeId);
        } else {
            param.put("cascadeId", orgNumber);
        }
        logger.info("[Param] Get consult user param=" + param);
        final ArrayList<ConsultMessage> result = new ArrayList<ConsultMessage>();
        this.getNamedJdbcTemplate().query(sql.toString(), param, (ResultSetExtractor)new ResultSetExtractor<List<ConsultMessage>>(){

            public List<ConsultMessage> extractData(ResultSet rs) throws SQLException, DataAccessException {
                while (rs.next()) {
                    ConsultMessage message = MessageDaoImpl.this.extractMessage(rs);
                    if (message == null) continue;
                    result.add(message);
                }
                return result;
            }
        });
        return result;
    }

    @Override
    public List<ConsultMessage> selectDialogMsgByUserId(UserIdentify user1, UserIdentify user2, long msgId, int limit) {
        return null;
    }

    private ConsultMessage extractMessage(ResultSet rs) {
        ConsultMessage message = null;
        try {
            message = new ConsultMessage();
            message.setId(rs.getLong("id"));
            message.setMsgType(rs.getInt("msg_type"));
            message.setConsultType(rs.getInt("consult_type"));
            message.setContent(rs.getString("content"));
            message.setUrl(rs.getString("url"));
            message.setHeight(rs.getInt("height"));
            message.setWidth(rs.getInt("width"));
            message.setLength(rs.getInt("length"));
            message.setSenderId(rs.getLong("sender_id"));
            message.setSenderNumber(rs.getLong("sender_number"));
            message.setSenderRole(rs.getInt("sender_role"));
            message.setReceiverId(rs.getLong("receiver_id"));
            message.setReceiverRole(rs.getInt("receiver_role"));
            message.setCreateTime(rs.getTimestamp("create_time"));
            message.setCallId(rs.getLong("call_id"));
        }
        catch (SQLException e) {
            logger.error("[ConsultMessage] Query Exception", (Throwable)e);
        }
        return message;
    }

    @Override
    public void insertMessage(ConsultMessage message) {
        message.setCreateTime(new Date());
        this.save(message, false, new String[0]);
    }

    @Override
    public List<ConsultMessage> getOrgStudentMessageListByMinId(Long minId, Date lastDate, int maxSize, String ... queryProps) {
        Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0, (Object)"maxSize is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.max("id", "id");
        builder.select("consultType");
        builder.groupByNames(new String[]{"senderId", "receiverId"});
        if (minId == null || minId == 0L) {
            if (lastDate == null) {
                throw new IllegalArgumentException("must have minId or lastDate");
            }
            builder.gt("createTime", (Serializable)lastDate);
        } else {
            builder.gt("id", (Serializable)minId);
        }
        Set<MsgUserRole> stuSet = MsgUserRole.getStuUsers();
        List<Integer> stuRoles = MsgUserRole.getRoles(stuSet);
        Set<MsgUserRole> orgSet = MsgUserRole.getOrgUsers();
        List<Integer> orgRoles = MsgUserRole.getRoles(orgSet);
        builder.in("senderRole", stuRoles);
        builder.in("receiverRole", orgRoles);
        builder.asc("createTime");
        builder.setMaxSize(Integer.valueOf(maxSize));
        return this.queryList(builder);
    }

    public List<ConsultMessage> selectMessageListByUserId(long userId) {
        String sql = "select * from yunying.tx_message_record where receiver_id = :userId";
        Map<String, Object> param = DbParamBuilder.getInstance().add("userId", userId).build();
        final ArrayList<ConsultMessage> result = new ArrayList<ConsultMessage>();
        this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<List<ConsultMessage>>(){

            public List<ConsultMessage> extractData(ResultSet rs) throws SQLException, DataAccessException {
                while (rs.next()) {
                    ConsultMessage message = MessageDaoImpl.this.extractMessage(rs);
                    if (message == null) continue;
                    result.add(message);
                }
                return result;
            }
        });
        return result;
    }

    @Override
    public Map<String, Long> getOrgLeaveBill(Long orgNumber, Date startTime, Date endTime) {
        String sql = "SELECT date(create_time) as t1,count(1) as t2 FROM yunying.tx_message_record where receiver_role=6 and receiver_id=:receiver_id  and consult_type=3  and create_time>=:startTime and create_time<=:endTime group by date(create_time)";
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("receiver_id", orgNumber);
        paramMap.put("startTime", startTime);
        paramMap.put("endTime", endTime);
        final LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
        this.getNamedJdbcTemplate().query(sql, (Map)paramMap, (ResultSetExtractor)new ResultSetExtractor<Map<String, Long>>(){

            public Map<String, Long> extractData(ResultSet rs) throws SQLException, DataAccessException {
                while (rs.next()) {
                    result.put(rs.getString("t1"), rs.getLong("t2"));
                }
                return result;
            }
        });
        return result;
    }

    @Override
    public int getOrgLeaveBillCount(Long orgNumber) {
        String sql = "SELECT count(1) FROM yunying.tx_message_record where receiver_role=6 and receiver_id=:receiver_id  and consult_type=3";
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("receiver_id", orgNumber);
        return this.getNamedJdbcTemplate().queryForInt(sql, (Map)paramMap);
    }

    @Override
    public Map<String, Long> getOrgCall(Long orgNumber, Date startTime, Date endTime) {
        String sql = "SELECT date(create_time) as t1,count(1) as t2 FROM yunying.tx_message_record where receiver_role=6 and receiver_id=:receiver_id  and consult_type=1  and create_time>=:startTime and create_time<=:endTime group by date(create_time)";
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("receiver_id", orgNumber);
        paramMap.put("startTime", startTime);
        paramMap.put("endTime", endTime);
        final LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
        this.getNamedJdbcTemplate().query(sql, (Map)paramMap, (ResultSetExtractor)new ResultSetExtractor<Map<String, Long>>(){

            public Map<String, Long> extractData(ResultSet rs) throws SQLException, DataAccessException {
                while (rs.next()) {
                    result.put(rs.getString("t1"), rs.getLong("t2"));
                }
                return result;
            }
        });
        return result;
    }

    @Override
    public int getOrgCallCount(Long orgNumber) {
        String sql = "SELECT count(1) FROM yunying.tx_message_record where receiver_role=6 and receiver_id=:receiver_id  and consult_type=1";
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("receiver_id", orgNumber);
        return this.getNamedJdbcTemplate().queryForInt(sql, (Map)paramMap);
    }

    @Override
    public int getPeroidOrgLeaveBill(Long orgNumber, Date startTime, Date endTime) {
        String sql = "SELECT count(1) FROM yunying.tx_message_record where receiver_role=6 and receiver_id=:receiver_id  and consult_type=3 and create_time>=:startTime and create_time<=:endTime ";
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("receiver_id", orgNumber);
        paramMap.put("startTime", startTime);
        paramMap.put("endTime", endTime);
        return this.getNamedJdbcTemplate().queryForInt(sql, (Map)paramMap);
    }

    @Override
    public int getPeroidOrgCall(Long orgNumber, Date startTime, Date endTime) {
        String sql = "SELECT count(1) FROM yunying.tx_message_record where receiver_role=6 and receiver_id=:receiver_id  and consult_type=1 and create_time>=:startTime and create_time<=:endTime ";
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("receiver_id", orgNumber);
        paramMap.put("startTime", startTime);
        paramMap.put("endTime", endTime);
        return this.getNamedJdbcTemplate().queryForInt(sql, (Map)paramMap);
    }

    @Override
    public void refreshConsultMessage(Long orgNumber, Long id) {
        StringBuilder sb = new StringBuilder("update yunying.tx_message_record set receiver_id = -1 where id > :id and  receiver_id = :orgNumber");
        HashMap param = Maps.newHashMap();
        param.put("orgNumber", orgNumber);
        param.put("id", id);
        this.getNamedJdbcTemplate().update(sb.toString(), (Map)param);
        StringBuilder sb1 = new StringBuilder("update yunying.tx_message_record set sender_id = -1 where id > :id and  sender_id = :orgNumber");
        HashMap param1 = Maps.newHashMap();
        param1.put("orgNumber", orgNumber);
        param1.put("id", id);
        this.getNamedJdbcTemplate().update(sb1.toString(), (Map)param1);
    }

    @Override
    public Integer getOrgClueTotal(Long orgNumber) {
        String sql = "select count(*) from yunying.tx_message_record where receiver_role=6 and receiver_id=:receiver_id";
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("receiver_id", orgNumber);
        return this.getNamedJdbcTemplate().queryForInt(sql, param);
    }

    @Override
    public Integer getPeriodOrgClue(Long orgNumber, String startTime, String endTime) {
        String sql = "select count(*) from yunying.tx_message_record where receiver_role=6 and receiver_id=:receiver_id and create_time>=:startTime and create_time<=:endTime";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("receiver_id", orgNumber);
        param.put("startTime", startTime);
        param.put("endTime", endTime);
        return this.getNamedJdbcTemplate().queryForInt(sql, param);
    }

    @Override
    public Integer getOrgWechatClue(Long orgNumber) {
        String sql = "SELECT count(1) FROM yunying.tx_message_record where receiver_role=6 and receiver_id=:receiver_id  and consult_type=2";
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("receiver_id", orgNumber);
        return this.getNamedJdbcTemplate().queryForInt(sql, param);
    }

    @Override
    public Integer getPeriodOrgWechatClue(Long orgNumber, String startTime, String endTime) {
        String sql = "SELECT count(1) FROM yunying.tx_message_record where receiver_role=6 and receiver_id=:receiver_id  and consult_type=2 and create_time>=:startTime and create_time<=:endTime ";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("receiver_id", orgNumber);
        param.put("startTime", startTime);
        param.put("endTime", endTime);
        return this.getNamedJdbcTemplate().queryForInt(sql, param);
    }

    @Override
    public List<Long> getExistOrgNumbers() {
        String sql = "select receiver_id from yunying.tx_message_record where receiver_role=6 group by receiver_id";
        return (List)this.getNamedJdbcTemplate().query(sql, (ResultSetExtractor)new ResultSetExtractor<List<Long>>(){

            public List<Long> extractData(ResultSet rs) throws SQLException, DataAccessException {
                ArrayList<Long> orgNumbers = new ArrayList<Long>();
                while (rs.next()) {
                    Long orgNumber = rs.getLong("receiver_id");
                    orgNumbers.add(orgNumber);
                }
                return orgNumbers;
            }
        });
    }

    @Override
    public Map<Integer, Integer> getConsultCountByType(Date startDate, Date endDate, int consultType, List<Integer> TianxiaoOrgNumbers) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgNumbers", TianxiaoOrgNumbers);
        String sql = "SELECT receiver_id, count(id) count FROM yunying.tx_message_record where receiver_id in (:orgNumbers) and consult_type= :consultType ";
        param.put("consultType", consultType);
        if (startDate != null && endDate != null) {
            sql = sql + " and create_time>=:startTime and create_time<=:endTime";
            param.put("startTime", startDate);
            param.put("endTime", endDate);
        }
        sql = sql + " group by receiver_id";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new MsgExtractor());
    }

    @Override
    public Map<Integer, Integer> getConsultTotal(Date startDate, Date endDate, List<Integer> TianxiaoOrgNumbers) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgNumbers", TianxiaoOrgNumbers);
        String sql = "SELECT receiver_id, count(id) count FROM yunying.tx_message_record where receiver_role=6 and receiver_id in (:orgNumbers) ";
        if (startDate != null && endDate != null) {
            sql = sql + " and create_time>=:startTime and create_time<=:endTime ";
            param.put("startTime", startDate);
            param.put("endTime", endDate);
        }
        sql = sql + "group by receiver_id";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new MsgExtractor());
    }

    @Override
    public Map<String, Integer> getConsultTotalMap(Date startDate, Date endDate, List<Integer> TianxiaoOrgNumbers) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgNumbers", TianxiaoOrgNumbers);
        String sql = "SELECT count(id) count, DATE_FORMAT(create_time,'%y-%m-%d') 'createTime' FROM yunying.tx_message_record where receiver_role=6 and receiver_id in (:orgNumbers) ";
        sql = sql + " and create_time>=:startTime and create_time<=:endTime ";
        param.put("startTime", startDate);
        param.put("endTime", endDate);
        sql = sql + "group by MONTH(create_time),DAY(create_time)";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<String, Integer>>(){

            public Map<String, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                while (rs.next()) {
                    String date = rs.getString("createTime");
                    Integer count = rs.getInt("count");
                    log.info("createTime===========" + rs.getString("createTime") + "count==========" + count);
                    map.put(date, count);
                }
                return map;
            }
        });
    }

    @Override
    public List<ConsultMessageDto> getMsgDtoByOrgNumberOrCacadeId(Integer number, Integer orgRole, List<Integer> consultRoles) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("numberOrCascadeId", number);
        param.put("orgRole", orgRole);
        param.put("consultRoles", consultRoles);
        String sql = "select * from (select * from ((select sender_id as consult_id, sender_role as consult_role, consult_type, content, msg_type,  receiver_id as number_or_cascade_id, create_time from yunying.tx_message_record where receiver_id = :numberOrCascadeId and receiver_role = :orgRole and sender_role in (:consultRoles)) union ALL (select receiver_id as consult_id, receiver_role as consult_role, consult_type, content, msg_type, sender_id as number_or_cascade_id, create_time from yunying.tx_message_record where sender_id = :numberOrCascadeId and sender_role = :orgRole and receiver_role in (:consultRoles))) as A order by create_time desc) as B group by B.consult_id order by B.create_time desc limit 4";
        return (List)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<List<ConsultMessageDto>>(){

            public List<ConsultMessageDto> extractData(ResultSet rs) throws SQLException, DataAccessException {
                ArrayList<ConsultMessageDto> list = new ArrayList<ConsultMessageDto>();
                while (rs.next()) {
                    ConsultMessageDto consultMessageDto = MessageDaoImpl.this.getConsultMessageDto(rs);
                    list.add(consultMessageDto);
                }
                return list;
            }
        });
    }

    private ConsultMessageDto getConsultMessageDto(ResultSet rs) throws SQLException {
        ConsultMessageDto consultMessageDto = new ConsultMessageDto();
        consultMessageDto.setConsultId(rs.getLong("consult_id"));
        consultMessageDto.setConsultRole(rs.getInt("consult_role"));
        consultMessageDto.setConsultType(rs.getInt("consult_type"));
        consultMessageDto.setText(rs.getString("content"));
        consultMessageDto.setNumberOrCascadeId(rs.getInt("number_or_cascade_id"));
        consultMessageDto.setCreate_time(rs.getTimestamp("create_time"));
        consultMessageDto.setMsgType(rs.getInt("msg_type"));
        return consultMessageDto;
    }

    @Override
    public Integer getMsgTotal(Integer numberOrCascadeId, Integer orgRole, List<Integer> consultRoles, Integer typeSource, Date startTime, Date endTime) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("numberOrCascadeId", numberOrCascadeId);
        param.put("orgRole", orgRole);
        param.put("consultRoles", consultRoles);
        String sql = "select count(distinct consult_id) from ((select sender_id as consult_id, sender_role as consult_role, consult_type, content, msg_type, receiver_id as number_or_cascade_id, create_time from yunying.tx_message_record where receiver_id = :numberOrCascadeId and receiver_role = :orgRole and sender_role in (:consultRoles)) union ALL (select receiver_id as consult_id, receiver_role as consult_role, consult_type, content, msg_type, sender_id as number_or_cascade_id, create_time from yunying.tx_message_record where sender_id = :numberOrCascadeId and sender_role = :orgRole and receiver_role in (:consultRoles))) as A where 1=1 ";
        if (GenericsUtils.notNullAndEmpty((Object)typeSource)) {
            sql = sql + "and A.consult_type = :typeSource ";
            param.put("typeSource", typeSource);
        }
        if (GenericsUtils.notNullAndEmpty((Object)startTime)) {
            sql = sql + " and A.create_time between :startTime and :endTime ";
            param.put("startTime", startTime);
            param.put("endTime", endTime);
        }
        return (Integer)this.getNamedJdbcTemplate().queryForObject(sql, param, Integer.class);
    }

    @Override
    public List<ConsultMessageDto> getMsgListByFilter(Integer numberOrCascadeId, Integer orgRole, List<Integer> consultRoles, Integer typeSource, Date startTime, Date endTime, Integer start, Integer limit) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("numberOrCascadeId", numberOrCascadeId);
        param.put("orgRole", orgRole);
        param.put("consultRoles", consultRoles);
        String sql = "select * from (select * from ((select sender_id as consult_id, sender_role as consult_role, consult_type, content, msg_type,  receiver_id as number_or_cascade_id, create_time from yunying.tx_message_record where receiver_id = :numberOrCascadeId and receiver_role = :orgRole and sender_role in (:consultRoles)) union ALL (select receiver_id as consult_id, receiver_role as consult_role, consult_type, content, msg_type, sender_id as number_or_cascade_id, create_time from yunying.tx_message_record where sender_id = :numberOrCascadeId and sender_role = :orgRole and receiver_role in (:consultRoles)))  as A order by create_time desc) as B where 1=1 ";
        if (GenericsUtils.notNullAndEmpty((Object)typeSource)) {
            sql = sql + "and B.consult_type = :typeSource ";
            param.put("typeSource", typeSource);
        }
        if (GenericsUtils.notNullAndEmpty((Object)startTime)) {
            sql = sql + " and B.create_time between :startTime and :endTime ";
            param.put("startTime", startTime);
            param.put("endTime", endTime);
        }
        sql = sql + " group by B.consult_id order by B.create_time desc";
        if (GenericsUtils.notNullAndEmpty((Object)start)) {
            sql = sql + " limit :start, :limit";
            param.put("start", start);
            param.put("limit", limit);
        }
        return (List)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<List<ConsultMessageDto>>(){

            public List<ConsultMessageDto> extractData(ResultSet rs) throws SQLException, DataAccessException {
                ArrayList<ConsultMessageDto> list = new ArrayList<ConsultMessageDto>();
                while (rs.next()) {
                    ConsultMessageDto consultMessageDto = MessageDaoImpl.this.getConsultMessageDto(rs);
                    list.add(consultMessageDto);
                }
                return list;
            }
        });
    }

    @Override
    public List<ConsultMessage> selectDialogMsg(UserIdentify user1, UserIdentify user2, Long lastMsgId, int limit) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("user1Id", user1.getUserId());
        param.put("user1Type", user1.getAllRoleIds());
        param.put("user2Id", user2.getUserId());
        param.put("user2Type", user2.getAllRoleIds());
        param.put("lastMsgId", lastMsgId);
        param.put("limit", limit);
        String sql = "select * from yunying.tx_message_record where ((receiver_id = :user1Id and receiver_role in (:user1Type) and sender_id = :user2Id and sender_role in (:user2Type)) or (receiver_id = :user2Id and receiver_role in (:user2Type) and sender_id = :user1Id and sender_role in (:user1Type)))";
        if (lastMsgId != null) {
            sql = sql + " and id < :lastMsgId ";
        }
        sql = sql + " order by id desc limit :limit";
        return (List)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<List<ConsultMessage>>(){

            public List<ConsultMessage> extractData(ResultSet rs) throws SQLException, DataAccessException {
                ArrayList<ConsultMessage> list = new ArrayList<ConsultMessage>();
                while (rs.next()) {
                    ConsultMessage consultMessage = MessageDaoImpl.this.extractMessage(rs);
                    list.add(consultMessage);
                }
                return list;
            }
        });
    }

    @Override
    public List<ConsultMessage> selectMsgByPageDto(PageDto dto, int maxId, int minId) {
        String sql = "select * from yunying.tx_message_record where id<:maxId and id > :minId limit :start,:limit";
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("maxId", maxId);
        map.put("minId", minId);
        map.put("start", (dto.getPageNum() - 1) * dto.getPageSize());
        map.put("limit", dto.getPageSize());
        return this.getNamedJdbcTemplate().query(sql, map, (RowMapper)new RowMapper<ConsultMessage>(){

            public ConsultMessage mapRow(ResultSet rs, int rowNum) throws SQLException {
                return MessageDaoImpl.this.extractMessage(rs);
            }
        });
    }

    @Override
    public void update(ConsultMessage message) {
        log.info("[Message] ####=" + message.getContent());
        this.update(message, false, new String[0]);
    }

    private class MsgExtractor
    implements ResultSetExtractor<Map<Integer, Integer>> {
        private MsgExtractor() {
        }

        public Map<Integer, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
            HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
            while (rs.next()) {
                Integer orgNamber = rs.getInt("receiver_id");
                Integer count = rs.getInt("count");
                map.put(orgNamber, count);
            }
            return map;
        }
    }
}

