/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.push.constant;

import com.baijia.tianxiao.dal.roster.constant.ConsulterStatus;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public enum MsgUserRole {
    HEADER(1, "\u6821\u957f"),
    BRANCH_HEADER(2, "\u5206\u6821\u6821\u957f"),
    MANAGER(3, "\u4e3b\u7ba1"),
    STAFF(4, "\u666e\u901a\u5458\u5de5"),
    CONSULT(101, "\u54a8\u8be2\u5b66\u5458"),
    CLUE(102, "\u7ebf\u7d22"),
    STUDENT(103, "\u6b63\u5f0f\u5b66\u5458"),
    SYSTEM(10000, "\u7cfb\u7edf");

    private static final Set<MsgUserRole> stuSet;
    private static final Set<MsgUserRole> orgSet;
    private int value;
    private String desc;
    private static Map<Integer, MsgUserRole> mapping;
    private static Map<String, MsgUserRole> mappingDesc;

    private MsgUserRole(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static MsgUserRole getByCode(Integer code) {
        return mapping.get(code);
    }

    public static MsgUserRole getByDesc(String desc) {
        return mappingDesc.get(desc);
    }

    public int getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    public static Set<MsgUserRole> getStuUsers() {
        return Collections.unmodifiableSet(stuSet);
    }

    public static Set<MsgUserRole> getOrgUsers() {
        return Collections.unmodifiableSet(orgSet);
    }

    public static boolean isHeader(int value) {
        return value == MsgUserRole.HEADER.value || value == MsgUserRole.BRANCH_HEADER.value;
    }

    public static boolean isSubOrg(int value) {
        return value == MsgUserRole.MANAGER.value || value == MsgUserRole.STAFF.value;
    }

    public static boolean isOrg(int value) {
        MsgUserRole type = MsgUserRole.getByCode(value);
        return orgSet.contains((Object)type);
    }

    public static boolean isStu(int value) {
        MsgUserRole type = MsgUserRole.getByCode(value);
        return stuSet.contains((Object)type);
    }

    public static MsgUserRole getUserRole(int consulterStatus) {
        if (consulterStatus == ConsulterStatus.IS.getValue()) {
            return CLUE;
        }
        return CONSULT;
    }

    public static List<Integer> getRoles(Collection<MsgUserRole> roleTypes) {
        ArrayList<Integer> roles = new ArrayList<Integer>();
        for (MsgUserRole msgUserRole : roleTypes) {
            Integer role = msgUserRole.getValue();
            roles.add(role);
        }
        return roles;
    }

    public static String getText(MsgUserRole userType) {
        switch (userType) {
            case CONSULT: {
                return "\u54a8\u8be2";
            }
            case STUDENT: {
                return "\u5b66\u5458";
            }
            case CLUE: {
                return "\u7ebf\u7d22";
            }
            case SYSTEM: {
                return "\u7cfb\u7edf";
            }
            case HEADER: 
            case BRANCH_HEADER: 
            case MANAGER: 
            case STAFF: {
                return "\u540c\u4e8b";
            }
        }
        return "";
    }

    static {
        stuSet = new HashSet<MsgUserRole>();
        orgSet = new HashSet<MsgUserRole>();
        stuSet.add(CONSULT);
        stuSet.add(CLUE);
        stuSet.add(STUDENT);
        orgSet.add(STAFF);
        orgSet.add(MANAGER);
        orgSet.add(BRANCH_HEADER);
        orgSet.add(HEADER);
        mapping = Maps.newHashMap();
        mappingDesc = Maps.newHashMap();
        for (MsgUserRole cut : MsgUserRole.values()) {
            mapping.put(cut.value, cut);
        }
        for (MsgUserRole cut : MsgUserRole.values()) {
            mappingDesc.put(cut.desc, cut);
        }
    }
}

