/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.activity.dao.impl;

import com.baijia.tianxiao.dal.activity.dao.TemplateDao;
import com.baijia.tianxiao.dal.activity.dto.PageInfo;
import com.baijia.tianxiao.dal.activity.po.Template;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class TemplateDaoImpl
extends JdbcTemplateDaoSupport<Template>
implements TemplateDao {
    private static final Logger logger = LoggerFactory.getLogger(TemplateDaoImpl.class);

    public TemplateDaoImpl() {
        super(Template.class);
    }

    @Override
    public List<Template> selectTemplateListByTypeId(Collection<Integer> typeIds, PageInfo page) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (typeIds != null && typeIds.size() > 0) {
            builder.in("typeId", typeIds);
        }
        builder.setPage(page.getPageDto());
        builder.gt("id", (Serializable)page.getLastId());
        return this.queryList(builder);
    }

    @Override
    public void updateTemplateUseCount(Long templateId) {
        String sql = "update yunying.tx_activity_template set amount_of_usage = amount_of_usage+1 where id=:templateId";
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("templateId", templateId);
        this.getNamedJdbcTemplate().update(sql, param);
    }

    @Override
    public Template selectTemplateById(Integer templateId) {
        return (Template)this.getById(templateId, new String[0]);
    }

    @Override
    public List<Template> selectTemplateList() {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        return this.queryList(builder);
    }
}

