/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.activity.dao.draw.impl;

import com.baijia.tianxiao.dal.activity.dao.draw.DrawActivityDao;
import com.baijia.tianxiao.dal.activity.po.draw.DrawInfo;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

@Repository
public class DrawActivityDaoImpl
extends JdbcTemplateDaoSupport<DrawInfo>
implements DrawActivityDao {
    public DrawActivityDaoImpl() {
        super(DrawInfo.class);
    }

    @Override
    public Long addDrawActivity(DrawInfo di) {
        this.save(di, new String[0]);
        return di.getActivityId();
    }

    @Override
    public void updateDrawActivity(DrawInfo di) {
        this.update(di, new String[0]);
    }

    @Override
    public DrawInfo getDrawInfoDetail(Long activityId, Long orgId) {
        List queryList;
        if (activityId == null) {
            return null;
        }
        SingleSqlBuilder createSqlBuilder = this.createSqlBuilder(new String[0]);
        createSqlBuilder.eq("activityId", (Serializable)activityId);
        if (orgId != null) {
            createSqlBuilder.eq("orgId", (Serializable)orgId);
        }
        if (GenericsUtils.notNullAndEmpty((Object)(queryList = this.queryList(createSqlBuilder)))) {
            return (DrawInfo)queryList.get(0);
        }
        return null;
    }

    @Override
    public List<DrawInfo> listDrawActivity(Integer status, Long lastId, Long orgId, PageDto pageDto) {
        HashMap<String, Number> paramMap = new HashMap<String, Number>();
        paramMap.put("id", lastId);
        paramMap.put("orgId", orgId);
        paramMap.put("status", status);
        paramMap.put("firstIndex", (pageDto.getPageNum() - 1) * pageDto.getPageSize());
        paramMap.put("pageSize", pageDto.getPageSize());
        String sql = "select * from yunying.tx_draw_info o1, (select update_time from yunying.tx_draw_info where id = :id) o2  where o1.org_id =:orgId  and (o1.update_time < o2.update_time or (o1.update_time = o2.update_time and o1.id < :id))  order by o1.update_time desc,o1.id desc limit :firstIndex,:pageSize";
        if (lastId == null || lastId == 0L) {
            sql = "select * from yunying.tx_draw_info where org_id = :orgId order by update_time desc , id desc limit :firstIndex,:pageSize ";
            paramMap.remove("id");
        }
        return (List)this.getNamedJdbcTemplate().query(sql, paramMap, (ResultSetExtractor)new ResultSetExtractor<List<DrawInfo>>(){

            public List<DrawInfo> extractData(ResultSet rs) throws SQLException, DataAccessException {
                ArrayList<DrawInfo> activitys = new ArrayList<DrawInfo>();
                while (rs.next()) {
                    activitys.add(DrawActivityDaoImpl.this.toActivity(rs));
                }
                return activitys;
            }
        });
    }

    private DrawInfo toActivity(ResultSet rs) throws SQLException {
        DrawInfo activity = new DrawInfo();
        activity.setActivityId(rs.getLong("id"));
        activity.setContent(rs.getString("content"));
        activity.setName(rs.getString("name"));
        activity.setCreateTime(rs.getTimestamp("create_time"));
        activity.setUpdateTime(rs.getTimestamp("update_time"));
        activity.setStartTime(rs.getTimestamp("start_time"));
        activity.setEndTime(rs.getTimestamp("end_time"));
        activity.setOrgId(rs.getLong("org_id"));
        activity.setStatus(rs.getInt("status"));
        activity.setAdStatus(rs.getInt("ad_status"));
        activity.setAdUrl(rs.getString("ad_url"));
        activity.setSlogan(rs.getString("slogan"));
        activity.setCountLimit(rs.getInt("count_limit"));
        activity.setIntroduction(rs.getString("introduction"));
        activity.setTemplateId(rs.getInt("template_id"));
        activity.setTemplateTypeId(rs.getInt("template_type_id"));
        return activity;
    }

    @Override
    public Map<Long, List<Long>> getDrawActivitysByIds(List<Long> orgIds, Date startTime, Date endTime) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", orgIds);
        String sql = "select org_id, id from yunying.tx_draw_info where org_id in (:orgIds)";
        if (startTime != null) {
            sql = sql + " and create_time between :startTime and :endTime";
            param.put("startTime", startTime);
            param.put("endTime", endTime);
        }
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, List<Long>>>(){

            public Map<Long, List<Long>> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, List<Long>> map = new HashMap<Long, List<Long>>();
                while (rs.next()) {
                    List<Long> activityIds;
                    Long orgId = rs.getLong("org_id");
                    Long activityId = rs.getLong("id");
                    if (map.containsKey(orgId)) {
                        activityIds = (List)map.get(orgId);
                        activityIds.add(activityId);
                        continue;
                    }
                    activityIds = new ArrayList();
                    activityIds.add(activityId);
                    map.put(orgId, activityIds);
                }
                return map;
            }
        });
    }

    @Override
    public List<Long> getExistOrgIds(List<Long> TianxiaoOrgIds) {
        HashMap<String, List<Long>> param = new HashMap<String, List<Long>>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql = "select org_id from yunying.tx_draw_info where org_id in (:orgIds) group by org_id";
        return (List)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<List<Long>>(){

            public List<Long> extractData(ResultSet rs) throws SQLException, DataAccessException {
                ArrayList<Long> orgIds = new ArrayList<Long>();
                while (rs.next()) {
                    Long orgId = rs.getLong("org_id");
                    orgIds.add(orgId);
                }
                return orgIds;
            }
        });
    }

    @Override
    public List<DrawInfo> selectCurrentDraw(long orgId) {
        HashMap<String, Serializable> paramMap = new HashMap<String, Serializable>();
        paramMap.put("orgId", Long.valueOf(orgId));
        paramMap.put("status", Integer.valueOf(1));
        paramMap.put("currentTime", new Date());
        String sql = "select * from yunying.tx_draw_info where org_id = :orgId and end_time >= :currentTime";
        return (List)this.getNamedJdbcTemplate().query(sql, paramMap, (ResultSetExtractor)new ResultSetExtractor<List<DrawInfo>>(){

            public List<DrawInfo> extractData(ResultSet rs) throws SQLException, DataAccessException {
                ArrayList<DrawInfo> activitys = new ArrayList<DrawInfo>();
                while (rs.next()) {
                    activitys.add(DrawActivityDaoImpl.this.toActivity(rs));
                }
                return activitys;
            }
        });
    }
}

