/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.signup.dao.impl;

import com.baijia.tianxiao.dal.signup.dao.OrgSignupRefundDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class OrgSignupRefundDaoImpl
extends JdbcTemplateDaoSupport<OrgSignupRefund>
implements OrgSignupRefundDao {
    private static final Logger log = LoggerFactory.getLogger(OrgSignupRefundDaoImpl.class);

    OrgSignupRefundDaoImpl() {
        super(OrgSignupRefund.class);
    }

    @Override
    public List<OrgSignupRefund> getOrgSignupRefundListByMinId(Long minId, Date lastDate, int maxSize, String ... queryProps) {
        Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0, (Object)"maxSize is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        if (minId == null || minId == 0L) {
            if (lastDate == null) {
                throw new IllegalArgumentException("must have minId or lastDate");
            }
            builder.gt("createTime", (Serializable)lastDate);
            builder.asc("createTime");
        } else {
            builder.gt("id", (Serializable)minId);
            builder.asc("id");
        }
        builder.setMaxSize(Integer.valueOf(maxSize));
        return this.queryList(builder);
    }

    @Override
    public List<OrgSignupRefund> getOrgSignupRefundListByPurchaseId(Long orgId, Long purchaseId, Long courseId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("org_id", (Serializable)orgId);
        builder.eq("signup_purchase_id", (Serializable)purchaseId);
        builder.eq("course_id", (Serializable)courseId);
        return this.queryList(builder);
    }

    @Override
    public int getRefundTime(Long orgId, Long signupPurchaseId, Long courseId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("org_id", (Serializable)orgId);
        builder.eq("signup_purchase_id", (Serializable)signupPurchaseId);
        builder.eq("course_id", (Serializable)courseId);
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public List<OrgSignupRefund> getByPurcahseIds(Set<Long> purchaseIds) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("signup_purchase_id", purchaseIds);
        return this.queryList(builder);
    }
}

