/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.roster.constant;

import com.baijia.tianxiao.dal.commons.ConfigEnum;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public enum IntentionLevel {
    LEVEL_1(0, "\u4f4e", ""),
    LEVEL_2(1, "\u4e2d", ""),
    LEVEL_3(2, "\u9ad8", "");

    private static Map<Integer, String> map;
    private static Map<String, Integer> nameMap;
    private int value;
    private String label;
    private String img;

    public static String getLabel(Integer value) {
        String lab = map.get(value);
        return lab == null ? LEVEL_2.getLabel() : lab;
    }

    public static Integer getValue(String label) {
        return nameMap.get(label);
    }

    private IntentionLevel(int value, String label, String img) {
        this.value = value;
        this.label = label;
        this.img = img;
    }

    public int getValue() {
        return this.value;
    }

    public String getLabel() {
        return this.label;
    }

    public String getImg() {
        return this.img;
    }

    public static List<ConfigEnum> list() {
        ArrayList<ConfigEnum> list = new ArrayList<ConfigEnum>();
        for (IntentionLevel p : IntentionLevel.values()) {
            ConfigEnum po = new ConfigEnum();
            po.setValue(p.getValue());
            po.setLabel(p.getLabel());
            po.setImg(p.getImg());
            list.add(po);
        }
        return list;
    }

    public static List<Integer> listValues() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (IntentionLevel p : IntentionLevel.values()) {
            list.add(p.getValue());
        }
        return list;
    }

    static {
        map = Maps.newHashMap();
        nameMap = Maps.newHashMap();
        for (IntentionLevel p : IntentionLevel.values()) {
            map.put(p.getValue(), p.getLabel());
        }
        for (IntentionLevel p : IntentionLevel.values()) {
            nameMap.put(p.getLabel(), p.getValue());
        }
    }
}

