/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.push.constant;

import com.baijia.tianxiao.dal.commons.ConfigEnum;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public enum MessageSource {
    INPUT(0, "\u95e8\u5e97\u5230\u8bbf", true),
    TELEPHONE(1, "400\u7535\u8bdd", true),
    WECHAT(2, "\u5fae\u4fe1\u54a8\u8be2", true),
    APPOINTMENT(3, "\u9884\u7ea6\u7559\u5355", true),
    ONLINE_IM(4, "\u5728\u7ebf\u54a8\u8be2", true),
    MARKING(5, "\u63a8\u5e7f\u6d88\u606f", false),
    SIGNUP(6, "\u6d3b\u52a8\u62a5\u540d", true),
    CHOUJIANG(7, "\u62bd\u5956\u6d3b\u52a8", true),
    WEI_OFFICIAL(8, "\u5fae\u5b98\u7f51", false),
    STAFF_INFO(9, "\u540c\u4e8b\u6d88\u606f", false),
    IMPORT(10, "\u7ebf\u7d22\u5bfc\u5165", true),
    NOTICE(100, "\u901a\u77e5", false);

    private int value;
    private String desc;
    private boolean isConsultSource;
    private static List<Integer> noEditConsultType;
    private static Map<Integer, MessageSource> mapping;
    private static Map<Integer, String> originSignConsultMap;

    private MessageSource(int value, String desc, boolean isConsultSource) {
        this.value = value;
        this.desc = desc;
        this.isConsultSource = isConsultSource;
    }

    public static List<Integer> getNoEditConsultType() {
        return noEditConsultType;
    }

    public int getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    public static String getDesc(Integer code) {
        if (mapping.get(code) == null) {
            return null;
        }
        return mapping.get(code).getDesc();
    }

    public static MessageSource getByType(Integer code) {
        return mapping.get(code);
    }

    public String buildConsultTypeMsg(String msg) {
        String fmt = "%s$%s";
        return String.format(fmt, this.getValue(), msg);
    }

    public static String getOriginSignByType(Integer code) {
        return originSignConsultMap.get(code);
    }

    public static List<ConfigEnum> list() {
        ArrayList<ConfigEnum> list = new ArrayList<ConfigEnum>();
        for (MessageSource p : MessageSource.values()) {
            ConfigEnum po = new ConfigEnum();
            po.setValue(p.getValue());
            po.setLabel(p.getDesc());
            po.setImg("");
            list.add(po);
        }
        return list;
    }

    public static List<ConfigEnum> listConsultSource() {
        ArrayList<ConfigEnum> list = new ArrayList<ConfigEnum>();
        for (MessageSource p : MessageSource.values()) {
            if (!p.isConsultSource) continue;
            ConfigEnum po = new ConfigEnum();
            po.setValue(p.getValue());
            po.setLabel(p.getDesc());
            po.setImg("");
            list.add(po);
        }
        return list;
    }

    public static List<Integer> listValues() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (MessageSource p : MessageSource.values()) {
            list.add(p.getValue());
        }
        return list;
    }

    public static List<Integer> listConsultSourceValues() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (MessageSource p : MessageSource.values()) {
            if (!p.isConsultSource) continue;
            list.add(p.getValue());
        }
        return list;
    }

    public static String getText(MessageSource source) {
        switch (source) {
            case TELEPHONE: {
                return "400";
            }
            case WECHAT: {
                return "\u5fae\u4fe1";
            }
            case WEI_OFFICIAL: {
                return "\u5fae\u5b98\u7f51";
            }
            case APPOINTMENT: {
                return "\u7559\u5355";
            }
            case SIGNUP: {
                return "\u6d3b\u52a8";
            }
            case CHOUJIANG: {
                return "\u6d3b\u52a8";
            }
        }
        return null;
    }

    static {
        noEditConsultType = null;
        mapping = Maps.newHashMap();
        originSignConsultMap = Maps.newHashMap();
        for (MessageSource ct : MessageSource.values()) {
            mapping.put(ct.value, ct);
        }
        noEditConsultType = Lists.newArrayList((Object[])new Integer[]{MessageSource.APPOINTMENT.value, MessageSource.TELEPHONE.value});
        originSignConsultMap.put(MessageSource.TELEPHONE.value, MessageSource.TELEPHONE.desc);
        originSignConsultMap.put(MessageSource.APPOINTMENT.value, MessageSource.APPOINTMENT.desc);
        originSignConsultMap.put(MessageSource.SIGNUP.value, MessageSource.SIGNUP.desc);
        originSignConsultMap.put(MessageSource.CHOUJIANG.value, MessageSource.CHOUJIANG.desc);
    }
}

