/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.beust.jcommander.internal.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

@Repository
public class TXCascadeCredentialDaoImpl
extends JdbcTemplateDaoSupport<TXCascadeCredential>
implements TXCascadeCredentialDao {
    public TXCascadeCredentialDaoImpl() {
        super(TXCascadeCredential.class);
    }

    @Override
    public TXCascadeCredential getByMobile(String mobile) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("mobile", (Serializable)((Object)mobile));
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return (TXCascadeCredential)((Object)this.uniqueResult(builder));
    }

    @Override
    public List<TXCascadeCredential> getTxCascadCredentialListByCredentialIds(Collection<Integer> credentialIds) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("credentialIds", credentialIds);
        param.put("normal", DeleteStatus.NORMAL.getValue());
        String sql = "select * from yunying.tx_cascade_credential where id in (:credentialIds) and isdel = :normal order by name desc, mobile desc";
        return (List)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<List<TXCascadeCredential>>(){

            public List<TXCascadeCredential> extractData(ResultSet rs) throws SQLException, DataAccessException {
                ArrayList<TXCascadeCredential> txCascadCredentials = new ArrayList<TXCascadeCredential>();
                while (rs.next()) {
                    TXCascadeCredential txCascadCredential = new TXCascadeCredential();
                    txCascadCredential.setId(rs.getInt("id"));
                    txCascadCredential.setAvatar(rs.getString("avatar"));
                    txCascadCredential.setMobile(rs.getString("mobile"));
                    txCascadCredential.setName(rs.getString("name"));
                    txCascadCredentials.add(txCascadCredential);
                }
                return txCascadCredentials;
            }
        });
    }

    @Override
    public Map<Long, String> getTxCascadCredentialListByCascdeIds(Collection<Integer> cascadeIds) {
        if (cascadeIds.isEmpty()) {
            return Maps.newHashMap();
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("cascadeIds", cascadeIds);
        param.put("normal", DeleteStatus.NORMAL.getValue());
        String sql = "select tca.id,tcc.name from yunying.tx_cascade_credential tcc,yunying.tx_cascade_account tca where tcc.id=tca.credential_id and tca.id in (:cascadeIds) and tcc.isdel = :normal";
        final Map txCasCadeMap = Maps.newHashMap();
        this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, String>>(){

            public Map<Long, String> extractData(ResultSet resultSet) throws SQLException, DataAccessException {
                while (resultSet.next()) {
                    txCasCadeMap.put(resultSet.getLong("id"), resultSet.getString("name"));
                }
                return txCasCadeMap;
            }
        });
        return txCasCadeMap;
    }

    @Override
    public TXCascadeCredential getTXCascadeCredentialByCredentialId(Integer credentialId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("id", (Serializable)credentialId);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return (TXCascadeCredential)((Object)this.uniqueResult(builder));
    }

    @Override
    public Map<Long, String> getTxCascadCredentialNameByCascdeIds(Collection<Integer> cascadeIds) {
        if (cascadeIds.isEmpty()) {
            return Maps.newHashMap();
        }
        HashMap<String, Collection<Integer>> param = new HashMap<String, Collection<Integer>>();
        param.put("cascadeIds", cascadeIds);
        String sql = "select tca.id,tcc.name from yunying.tx_cascade_credential tcc,yunying.tx_cascade_account tca where tcc.id=tca.credential_id and tca.id in (:cascadeIds)";
        final Map txCasCadeMap = Maps.newHashMap();
        this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, String>>(){

            public Map<Long, String> extractData(ResultSet resultSet) throws SQLException, DataAccessException {
                while (resultSet.next()) {
                    txCasCadeMap.put(resultSet.getLong("id"), resultSet.getString("name"));
                }
                return txCasCadeMap;
            }
        });
        return txCasCadeMap;
    }

    @Override
    public Map<Integer, TXCascadeCredential> getTxCascadeNameAndAvatar(Collection<Integer> cascadeIds) {
        if (cascadeIds.isEmpty()) {
            return Maps.newHashMap();
        }
        HashMap<String, Collection<Integer>> param = new HashMap<String, Collection<Integer>>();
        param.put("cascadeIds", cascadeIds);
        String sql = "select tca.id,tcc.name,tcc.avatar from yunying.tx_cascade_credential tcc,yunying.tx_cascade_account tca where tcc.id=tca.credential_id and tca.id in (:cascadeIds)";
        final Map txCasCadeMap = Maps.newHashMap();
        this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Integer, TXCascadeCredential>>(){

            public Map<Integer, TXCascadeCredential> extractData(ResultSet resultSet) throws SQLException, DataAccessException {
                while (resultSet.next()) {
                    TXCascadeCredential credential = new TXCascadeCredential();
                    credential.setAvatar(resultSet.getString("avatar"));
                    credential.setName(resultSet.getString("name"));
                    txCasCadeMap.put(resultSet.getInt("id"), credential);
                }
                return txCasCadeMap;
            }
        });
        return txCasCadeMap;
    }
}

