/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountStatus;
import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

@Repository
public class TXAccountDaoImpl
extends JdbcTemplateDaoSupport<TXAccount>
implements TXAccountDao {
    public TXAccountDaoImpl() {
        super(TXAccount.class);
    }

    @Override
    public TXAccount getByOrgId(Integer orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.eq("status", (Serializable)TXAccountStatus.VALID.getCode());
        return (TXAccount)this.uniqueResult(builder);
    }

    @Override
    public TXAccount getByIdAndOrgId(Integer id, Integer orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("id", (Serializable)id);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.eq("status", (Serializable)TXAccountStatus.VALID.getCode());
        return (TXAccount)this.uniqueResult(builder);
    }

    @Override
    public TXAccount getByOrgNumber(Integer orgNumber) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgNumber", (Serializable)orgNumber);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return (TXAccount)this.uniqueResult(builder);
    }

    @Override
    public Map<Long, Integer> getAccountTypeMap(Collection<Long> orgIds) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", orgIds);
        param.put("isdel", DeleteStatus.NORMAL.getValue());
        param.put("status", TXAccountStatus.VALID.getCode());
        String sql = "select * from yunying.tx_account where org_id in (:orgIds) and isdel = :isdel and status = :status";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, Integer>>(){

            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, Integer> map = new HashMap<Long, Integer>();
                while (rs.next()) {
                    Long orgId = rs.getLong("org_id");
                    Integer type = rs.getInt("account_type");
                    map.put(orgId, type);
                }
                return map;
            }
        });
    }
}

