/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.constant.OrgSubAccountStatus;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class OrgSubAccountDaoImpl
extends JdbcTemplateDaoSupport<OrgSubAccount>
implements OrgSubAccountDao {
    public OrgSubAccountDaoImpl() {
        super(OrgSubAccount.class);
    }

    @Override
    public OrgSubAccount getMasterByOrgId(Integer orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("pid", (Serializable)Integer.valueOf(0));
        builder.eq("status", (Serializable)OrgSubAccountStatus.NORMAL.getCode());
        return (OrgSubAccount)this.uniqueResult(builder);
    }

    @Override
    public List<OrgSubAccount> getSlavesByMasterOrgId(Integer orgId, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("pid", (Serializable)orgId);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        if (pageDto != null) {
            builder.setPage(pageDto);
        }
        return this.queryList(builder);
    }

    @Override
    public List<OrgSubAccount> getSlavesIgnoreStatus(Integer orgId, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("pid", (Serializable)orgId);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        if (pageDto != null) {
            builder.setPage(pageDto);
        }
        return this.queryList(builder);
    }

    @Override
    public Integer getSlavesCountByMasterOrgId(Integer orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("pid", (Serializable)orgId);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public OrgSubAccount getByOrgId(Integer orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.eq("status", (Serializable)OrgSubAccountStatus.NORMAL.getCode());
        return (OrgSubAccount)this.uniqueResult(builder);
    }

    @Override
    public OrgSubAccount getSlaveIgnoreStatus(Integer orgId, Integer masterId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("pid", (Serializable)masterId);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return (OrgSubAccount)this.uniqueResult(builder);
    }

    @Override
    public List<OrgSubAccount> getOrgSubAccountByOrgIds(Collection<Long> orgIds, Integer status) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("orgId", orgIds);
        if (GenericsUtils.notNullAndEmpty((Object)status)) {
            builder.eq("status", (Serializable)status);
        }
        return this.queryList(builder);
    }
}

