/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

@Repository(value="orgAccountDao")
public class OrgAccountDaoImpl
extends JdbcTemplateDaoSupport<OrgAccount>
implements OrgAccountDao {
    public OrgAccountDaoImpl() {
        super(OrgAccount.class);
    }

    @Override
    public OrgAccount getAccountByNumber(Integer number, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("number", (Serializable)number);
        return (OrgAccount)this.uniqueResult(builder);
    }

    @Override
    public OrgAccount getAccountById(int id, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("id", (Serializable)Integer.valueOf(id));
        return (OrgAccount)this.uniqueResult(builder);
    }

    @Override
    public List<OrgAccount> getAccountByNumbers(Collection<Integer> numbers, final String ... queryProps) {
        if (CollectionUtils.isEmpty(numbers)) {
            return Collections.emptyList();
        }
        return (List)new ListBatchQueryTemplate().batchQuery(numbers, (BatchQueryCallback)new BatchQueryCallback<Integer, List<OrgAccount>>(){

            public List<OrgAccount> doQuery(Collection<Integer> querySet) {
                SingleSqlBuilder builder = OrgAccountDaoImpl.this.createSqlBuilder(queryProps);
                builder.in("number", querySet);
                return OrgAccountDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public OrgAccount getAccountByMobile(String mobile) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("mobile", (Serializable)((Object)mobile));
        return (OrgAccount)this.uniqueResult(builder);
    }

    @Override
    public Map<Long, Long> getOrgIdsByOrgNumbers(List<Long> orgNumbers) {
        HashMap<String, List<Long>> param = new HashMap<String, List<Long>>();
        param.put("orgNumbers", orgNumbers);
        String sql = "select id, number from yunying.org_account where number in (:orgNumbers)";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, Long>>(){

            public Map<Long, Long> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, Long> map = new HashMap<Long, Long>();
                while (rs.next()) {
                    Long orgNumber = rs.getLong("number");
                    Long orgId = rs.getLong("id");
                    map.put(orgNumber, orgId);
                }
                return map;
            }
        });
    }

    @Override
    public Map<Long, Integer> getorgNumbersByOrgIds(Collection<Long> orgIds) {
        HashMap<String, Collection<Long>> param = new HashMap<String, Collection<Long>>();
        param.put("orgIds", orgIds);
        String sql = "select id, number from yunying.org_account where id in (:orgIds)";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, Integer>>(){

            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, Integer> map = new HashMap<Long, Integer>();
                while (rs.next()) {
                    Integer orgNumber = rs.getInt("number");
                    Long orgId = rs.getLong("id");
                    map.put(orgId, orgNumber);
                }
                return map;
            }
        });
    }

    @Override
    public List<OrgAccount> getOrgAccountByOrgIds(Collection<Integer> orgIds) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return Collections.emptyList();
        }
        return (List)new ListBatchQueryTemplate().batchQuery(orgIds, (BatchQueryCallback)new BatchQueryCallback<Integer, List<OrgAccount>>(){

            public List<OrgAccount> doQuery(Collection<Integer> querySet) {
                SingleSqlBuilder builder = OrgAccountDaoImpl.this.createSqlBuilder(new String[0]);
                builder.in("id", querySet);
                return OrgAccountDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public Map<Integer, Long> batchSearchOrgIds(List<Integer> orgNumbers) {
        HashMap<String, List<Integer>> param = new HashMap<String, List<Integer>>();
        param.put("orgNumbers", orgNumbers);
        String sql = "select id, number from yunying.org_account where number in (:orgNumbers)";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Integer, Long>>(){

            public Map<Integer, Long> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Integer, Long> map = new HashMap<Integer, Long>();
                while (rs.next()) {
                    Integer orgNumber = rs.getInt("number");
                    Long orgId = rs.getLong("id");
                    map.put(orgNumber, orgId);
                }
                return map;
            }
        });
    }
}

