/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.msg.dao.impl;

import com.baijia.tianxiao.dal.commons.OrgStatisticsExtractor;
import com.baijia.tianxiao.dal.msg.dao.TxSmsDao;
import com.baijia.tianxiao.dal.msg.po.TxSms;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

@Repository
public class TxSmsDaoImpl
extends JdbcTemplateDaoSupport<TxSms>
implements TxSmsDao {
    @Override
    public Integer getTxSmsTotal(Integer orgId, Integer senderRole, Integer sendResult, String startDate, String endDate) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("senderId", (Serializable)orgId);
        if (senderRole != null) {
            builder.eq("senderRole", (Serializable)senderRole);
        }
        if (sendResult != null) {
            builder.eq("sendResult", (Serializable)sendResult);
        }
        if (startDate != null && endDate != null) {
            builder.between("createTime", (Comparable)((Object)startDate), (Comparable)((Object)endDate));
        }
        builder.count("id");
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public Map<Long, Integer> getOrgTxSmsCount(Date startTime, Date endTime, List<Long> TianxiaoOrgIds) {
        String sql = "select count(1) as count,sender_id as org_id from yunying.tx_sms where sender_role = 6 and sender_id in (:orgIds)";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", TianxiaoOrgIds);
        if (startTime != null && endTime != null) {
            sql = sql + " and create_time between :startDate and :endDate";
            param.put("startDate", startTime);
            param.put("endDate", endTime);
        }
        sql = sql + " GROUP BY sender_id";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new OrgStatisticsExtractor());
    }
}

