/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.advisory.dao.impl;

import com.baijia.tianxiao.dal.advisory.dao.OrgCallRecorderDao;
import com.baijia.tianxiao.dal.advisory.dao.dto.CallStatisticDto;
import com.baijia.tianxiao.dal.advisory.po.OrgCallRecordCount;
import com.baijia.tianxiao.dal.advisory.po.OrgCallRecorder;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.Expression;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.sqlbuilder.util.Expressions;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class OrgCallRecorderDaoImpl
extends JdbcTemplateDaoSupport<OrgCallRecorder>
implements OrgCallRecorderDao {
    private static final Logger log = LoggerFactory.getLogger(OrgCallRecorderDaoImpl.class);

    public OrgCallRecorderDaoImpl() {
        super(OrgCallRecorder.class);
    }

    @Override
    public List<OrgCallRecorder> query(Date startTime, Date endTime, String extension, String key, Collection<Integer> statuses, PageDto page) {
        if (StringUtils.isBlank((CharSequence)extension)) {
            return Collections.emptyList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{key})) {
            builder.or(Expressions.like((String)"customerNumber", (Serializable)((Object)key), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"connectedNumber", (Serializable)((Object)key), (MatchMode)MatchMode.ANYWHERE));
        }
        if (CollectionUtils.isNotEmpty(statuses)) {
            Expression inExpression = Expressions.in((String)"processStatus", statuses);
            if (statuses.contains(50) && statuses.contains(51)) {
                builder.or(Expressions.eq((String)"processStatus", (Serializable)Integer.valueOf(0)), inExpression);
            } else if (statuses.contains(50)) {
                builder.or(Expressions.and((Expression)Expressions.eq((String)"processStatus", (Serializable)Integer.valueOf(0)), (Expression)Expressions.eq((String)"status", (Serializable)Integer.valueOf(1))), inExpression);
            } else if (statuses.contains(51)) {
                builder.or(Expressions.and((Expression)Expressions.eq((String)"processStatus", (Serializable)Integer.valueOf(0)), (Expression)Expressions.ne((String)"status", (Serializable)Integer.valueOf(1))), inExpression);
            } else {
                builder.add(inExpression);
            }
        }
        if (startTime != null && endTime != null) {
            builder.between("startTime", (Comparable)startTime, (Comparable)endTime);
        }
        builder.eq("extention", (Serializable)((Object)extension));
        builder.desc("startTime");
        builder.setPage(page);
        return this.queryList(builder);
    }

    @Override
    public List<String> getExtentions(Date startTime, Date endTime, String key, Integer areaId) {
        HashMap nameValueMap = Maps.newHashMap();
        StringBuilder builder = new StringBuilder();
        builder.append("select record.extention ");
        builder.append("from yunying.callservice_org_call_record record inner join yunying.org_info org on record.extention = org.extension ");
        builder.append("where record.start_time between :startTime_l and :startTime_r AND length(record.extention) = 6  ");
        if (StringUtils.isNotEmpty((CharSequence)key)) {
            builder.append("and (record.customer_number like :name or record.connected_number like :name ");
            builder.append("or org.name like :name or org.shortname like :name) ");
            nameValueMap.put("name", key + "%");
        }
        if (areaId != null) {
            builder.append("and org.area_id =:areaId ");
            nameValueMap.put("areaId", areaId);
        }
        nameValueMap.put("startTime_l", startTime);
        nameValueMap.put("startTime_r", endTime);
        log.debug(builder.toString());
        log.debug("-----------------------------result={}", (Object)this.getNamedJdbcTemplate().queryForList(builder.toString(), (Map)nameValueMap, String.class));
        List list = this.getNamedJdbcTemplate().queryForList(builder.toString(), (Map)nameValueMap, String.class);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return list;
        }
        return Lists.newArrayList();
    }

    @Override
    public List<OrgCallRecorder> query(Date startTime, Date endTime, Collection<String> extensions, PageDto page) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (startTime != null && endTime != null) {
            builder.between("startTime", (Comparable)startTime, (Comparable)endTime);
        }
        if (CollectionUtils.isNotEmpty(extensions)) {
            builder.in("extention", extensions);
        }
        builder.desc("startTime");
        builder.setPage(page);
        return this.queryList(builder);
    }

    @Override
    public Integer queryCount(Date startTime, Date endTime, Collection<String> extensions, Integer status, Integer processStatus) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (startTime != null && endTime != null) {
            builder.between("startTime", (Comparable)startTime, (Comparable)endTime);
        }
        if (CollectionUtils.isNotEmpty(extensions)) {
            builder.in("extention", extensions);
        }
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        if (processStatus != null) {
            builder.eq("processStatus", (Serializable)processStatus);
        }
        builder.desc("startTime");
        builder.count("id");
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public OrgCallRecordCount queryOrgCallRecordCount(Date startTime, Date endTime, Collection<String> extensions) {
        String sql = "select sum(case when process_status=50 then 1 when process_status=0 and status = 1 then 1 else 0 end) answered,sum(case when process_status=51 then 1 when process_status=0 and status in (2,3) then 1 else 0 end) notAnswered, sum(case when process_status=20 then 1 else 0 end) needCallBack,sum(case when process_status=52 then 1 else 0 end) complete from yunying.callservice_org_call_record where extention in (:extention) and start_time between :startTime_l and :startTime_r order by start_time desc";
        HashMap nameValueMap = Maps.newHashMap();
        nameValueMap.put("extention", extensions);
        nameValueMap.put("startTime_l", startTime);
        nameValueMap.put("startTime_r", endTime);
        return (OrgCallRecordCount)this.getNamedJdbcTemplate().queryForObject(sql, (Map)nameValueMap, (RowMapper)new BeanPropertyRowMapper(OrgCallRecordCount.class));
    }

    @Override
    public Map<String, Object> queryCallCountAndTime(String mobile, String extension) {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mobile}), (Object)"mobile can not be null");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{extension}), (Object)"org extension is null");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.max("startTime", "MAX_TIME");
        builder.eq("customerNumber", (Serializable)((Object)mobile));
        builder.eq("extention", (Serializable)((Object)extension));
        String sql = builder.toSql();
        Map paramMap = builder.collectConditionValue();
        log.debug("query sql:{},param:{}", (Object)sql, (Object)paramMap);
        return this.getNamedJdbcTemplate().queryForMap(sql, paramMap);
    }

    @Override
    public Map<String, CallStatisticDto> getCallStatisticDtoMapByExtensions(Date startTime, Date endTime, Collection<String> extensions) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("extensions", extensions);
        String sql = "select extention, count(1) count, sum(during_time) duration from yunying.callservice_org_call_record where extention in (:extensions) ";
        if (startTime != null) {
            sql = sql + " and start_time between :startTime and :endTime ";
            param.put("startTime", startTime);
            param.put("endTime", endTime);
        }
        sql = sql + " group by extention";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<String, CallStatisticDto>>(){

            public Map<String, CallStatisticDto> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<String, CallStatisticDto> map = new HashMap<String, CallStatisticDto>();
                while (rs.next()) {
                    String extention = rs.getString("extention");
                    Integer count = rs.getInt("count");
                    Integer duration = rs.getInt("duration");
                    CallStatisticDto dto = new CallStatisticDto();
                    dto.setCount(count);
                    dto.setDuration(duration);
                    map.put(extention, dto);
                }
                return map;
            }
        });
    }

    @Override
    public Integer getOrgCallRecordCountByExtexsion(Date startTime, Date endTime, String extention) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("extention", extention);
        String sql = "select count(1) count  from yunying.callservice_org_call_record where extention = :extention";
        if (startTime != null) {
            sql = sql + " and start_time between :startTime and :endTime";
            param.put("startTime", startTime);
            param.put("endTime", endTime);
        }
        return (Integer)this.getNamedJdbcTemplate().queryForObject(sql, param, Integer.class);
    }

    @Override
    public Integer getOrgCallRecordTimeByExtension(Date startTime, Date endTime, String extension) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("extention", extension);
        String sql = "select sum(during_time)  from yunying.callservice_org_call_record where extention = :extention";
        if (startTime != null) {
            sql = sql + " and start_time between :startTime and :endTime";
            param.put("startTime", startTime);
            param.put("endTime", endTime);
        }
        return (Integer)this.getNamedJdbcTemplate().queryForObject(sql, param, Integer.class);
    }
}

