/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.signup.dao.impl;

import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Repository;

@Repository
public class OrgSignupCourseDaoImpl
extends JdbcTemplateDaoSupport<OrgSignupCourse>
implements OrgSignupCourseDao {
    public OrgSignupCourseDaoImpl() {
        super(OrgSignupCourse.class);
    }

    @Override
    public List<Long> searchPurchaseIdByCourseId(@NonNull Collection<Long> courseIds, Date startTime, Date endTime) {
        if (courseIds == null) {
            throw new NullPointerException("courseIds");
        }
        if (CollectionUtils.isEmpty(courseIds)) {
            return Collections.emptyList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.select("signupPurchaseId");
        builder.in("orgCourseId", courseIds);
        if (startTime != null) {
            builder.ge("createTime", (Serializable)startTime);
        }
        if (endTime != null) {
            builder.le("createTime", (Serializable)endTime);
        }
        return this.queryForList(builder, Long.class);
    }

    @Override
    public List<OrgSignupCourse> loadByPurchaseIds(@NonNull Collection<Long> purchaseIds, final String ... queryProps) {
        if (purchaseIds == null) {
            throw new NullPointerException("purchaseIds");
        }
        if (CollectionUtils.isEmpty(purchaseIds)) {
            return Collections.emptyList();
        }
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        return (List)queryTemplate.batchQuery(purchaseIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgSignupCourse>>(){

            public List<OrgSignupCourse> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgSignupCourseDaoImpl.this.createSqlBuilder(new String[0]);
                builder.select(queryProps);
                builder.in("signupPurchaseId", querySet);
                return OrgSignupCourseDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public List<OrgSignupCourse> loadByPurchaseId(@NonNull Long purchaseId, String ... queryProps) {
        if (purchaseId == null) {
            throw new NullPointerException("purchaseId");
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.select(queryProps);
        builder.eq("signupPurchaseId", (Serializable)purchaseId);
        return this.queryList(builder);
    }

    @Override
    public void saveOrUpdateSignupCourse(@NonNull OrgSignupCourse signupCourse) {
        if (signupCourse == null) {
            throw new NullPointerException("signupCourse");
        }
        if (signupCourse.getId() > 0) {
            this.update(signupCourse, new String[0]);
        } else {
            this.save(signupCourse, new String[0]);
        }
    }

    public void updateByCourseId(@NonNull OrgSignupCourse signupCourse) {
        if (signupCourse == null) {
            throw new NullPointerException("signupCourse");
        }
        HashMap updateCondition = Maps.newHashMap();
        updateCondition.put("orgCourseId", signupCourse.getOrgCourseId());
        this.update(updateCondition, signupCourse, new String[0]);
    }

    @Override
    public void saveSignupCourses(List<OrgSignupCourse> courses) {
        this.saveAll(courses, new String[0]);
    }
}

