/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.push.dao.impl;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.dal.push.dao.MessageDao;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.push.utils.DbParamBuilder;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

@Repository
public class MessageDaoImpl
extends JdbcTemplateDaoSupport<ConsultMessage>
implements MessageDao {
    private static final Logger logger = LoggerFactory.getLogger(MessageDaoImpl.class);

    public MessageDaoImpl() {
        super(ConsultMessage.class);
    }

    @Override
    public void batchInsertMessage(List<ConsultMessage> messages) {
    }

    @Override
    public List<ConsultMessage> selectNewRecordByUserId(long userId, long msgId, int limit) {
        String sql = "select * from yunying.tx_message_record where receiver_id = :userId AND id > :msgId union ALL select * from yunying.tx_message_record where sender_id = :userId AND id > :msgId order by id desc limit :limit";
        Map<String, Object> param = DbParamBuilder.getInstance().add("userId", userId).add("msgId", msgId).add("limit", limit).build();
        final ArrayList<ConsultMessage> result = new ArrayList<ConsultMessage>();
        this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<List<ConsultMessage>>(){

            public List<ConsultMessage> extractData(ResultSet rs) throws SQLException, DataAccessException {
                while (rs.next()) {
                    ConsultMessage message = MessageDaoImpl.this.extractMessage(rs);
                    if (message == null) continue;
                    result.add(message);
                }
                return result;
            }
        });
        return result;
    }

    private ConsultMessage extractMessage(ResultSet rs) {
        ConsultMessage message = null;
        try {
            message = new ConsultMessage();
            message.setId(rs.getLong("id"));
            message.setMsgType(rs.getInt("msg_type"));
            message.setConsultType(rs.getInt("consult_type"));
            message.setText(rs.getString("content"));
            message.setUrl(rs.getString("url"));
            message.setHeight(rs.getInt("height"));
            message.setWidth(rs.getInt("width"));
            message.setLength(rs.getInt("length"));
            message.setSenderId(rs.getLong("sender_id"));
            message.setSenderNumber(rs.getLong("sender_number"));
            message.setSenderRole(rs.getInt("sender_role"));
            message.setReceiverId(rs.getLong("receiver_id"));
            message.setReceiverRole(rs.getInt("receiver_role"));
            message.setCreateTime(rs.getTimestamp("create_time"));
            message.setCallId(rs.getLong("call_id"));
        }
        catch (SQLException e) {
            logger.error("[ConsultMessage] Query Exception", (Throwable)e);
        }
        return message;
    }

    @Override
    public void insertMessage(ConsultMessage message) {
        message.setCreateTime(new Date());
        this.save(message, false, new String[0]);
    }

    @Override
    public List<ConsultMessage> getOrgStudentMessageListByMinId(Long minId, Date lastDate, int maxSize, String ... queryProps) {
        Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0, (Object)"maxSize is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.max("id", "id");
        builder.select("consultType");
        builder.groupByNames(new String[]{"senderId", "receiverId"});
        if (minId == null || minId == 0L) {
            if (lastDate == null) {
                throw new IllegalArgumentException("must have minId or lastDate");
            }
            builder.gt("createTime", (Serializable)lastDate);
        } else {
            builder.gt("id", (Serializable)minId);
        }
        builder.eq("senderRole", (Serializable)Integer.valueOf(UserRole.STUDENT.getRole()));
        builder.eq("receiverRole", (Serializable)Integer.valueOf(UserRole.ORGANIZATION.getRole()));
        builder.asc("createTime");
        builder.setMaxSize(Integer.valueOf(maxSize));
        return this.queryList(builder);
    }

    public List<ConsultMessage> selectMessageListByUserId(long userId) {
        String sql = "select * from yunying.tx_message_record where receiver_id = :userId";
        Map<String, Object> param = DbParamBuilder.getInstance().add("userId", userId).build();
        final ArrayList<ConsultMessage> result = new ArrayList<ConsultMessage>();
        this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<List<ConsultMessage>>(){

            public List<ConsultMessage> extractData(ResultSet rs) throws SQLException, DataAccessException {
                while (rs.next()) {
                    ConsultMessage message = MessageDaoImpl.this.extractMessage(rs);
                    if (message == null) continue;
                    result.add(message);
                }
                return result;
            }
        });
        return result;
    }

    @Override
    public Map<String, Long> getOrgLeaveBill(Long orgNumber, Date startTime, Date endTime) {
        String sql = "SELECT date(create_time) as t1,count(1) as t2 FROM yunying.tx_message_record where receiver_role=6 and receiver_id=:receiver_id  and consult_type=3  and create_time>=:startTime and create_time<=:endTime group by date(create_time)";
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("receiver_id", orgNumber);
        paramMap.put("startTime", startTime);
        paramMap.put("endTime", endTime);
        final LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
        this.getNamedJdbcTemplate().query(sql, (Map)paramMap, (ResultSetExtractor)new ResultSetExtractor<Map<String, Long>>(){

            public Map<String, Long> extractData(ResultSet rs) throws SQLException, DataAccessException {
                while (rs.next()) {
                    result.put(rs.getString("t1"), rs.getLong("t2"));
                }
                return result;
            }
        });
        return result;
    }

    @Override
    public int getOrgLeaveBillCount(Long orgNumber) {
        String sql = "SELECT count(1) FROM yunying.tx_message_record where receiver_role=6 and receiver_id=:receiver_id  and consult_type=3";
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("receiver_id", orgNumber);
        return this.getNamedJdbcTemplate().queryForInt(sql, (Map)paramMap);
    }

    @Override
    public Map<String, Long> getOrgCall(Long orgNumber, Date startTime, Date endTime) {
        String sql = "SELECT date(create_time) as t1,count(1) as t2 FROM yunying.tx_message_record where receiver_role=6 and receiver_id=:receiver_id  and consult_type=1  and create_time>=:startTime and create_time<=:endTime group by date(create_time)";
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("receiver_id", orgNumber);
        paramMap.put("startTime", startTime);
        paramMap.put("endTime", endTime);
        final LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
        this.getNamedJdbcTemplate().query(sql, (Map)paramMap, (ResultSetExtractor)new ResultSetExtractor<Map<String, Long>>(){

            public Map<String, Long> extractData(ResultSet rs) throws SQLException, DataAccessException {
                while (rs.next()) {
                    result.put(rs.getString("t1"), rs.getLong("t2"));
                }
                return result;
            }
        });
        return result;
    }

    @Override
    public int getOrgCallCount(Long orgNumber) {
        String sql = "SELECT count(1) FROM yunying.tx_message_record where receiver_role=6 and receiver_id=:receiver_id  and consult_type=1";
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("receiver_id", orgNumber);
        return this.getNamedJdbcTemplate().queryForInt(sql, (Map)paramMap);
    }

    @Override
    public int getPeroidOrgLeaveBill(Long orgNumber, Date startTime, Date endTime) {
        String sql = "SELECT count(1) FROM yunying.tx_message_record where receiver_role=6 and receiver_id=:receiver_id  and consult_type=3 and create_time>=:startTime and create_time<=:endTime ";
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("receiver_id", orgNumber);
        paramMap.put("startTime", startTime);
        paramMap.put("endTime", endTime);
        return this.getNamedJdbcTemplate().queryForInt(sql, (Map)paramMap);
    }

    @Override
    public int getPeroidOrgCall(Long orgNumber, Date startTime, Date endTime) {
        String sql = "SELECT count(1) FROM yunying.tx_message_record where receiver_role=6 and receiver_id=:receiver_id  and consult_type=1 and create_time>=:startTime and create_time<=:endTime ";
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("receiver_id", orgNumber);
        paramMap.put("startTime", startTime);
        paramMap.put("endTime", endTime);
        return this.getNamedJdbcTemplate().queryForInt(sql, (Map)paramMap);
    }

    @Override
    public void refreshConsultMessage(Long orgNumber, Long id) {
        StringBuilder sb = new StringBuilder("update yunying.tx_message_record set receiver_id = null where id >:id and  receiver_id = :orgNumber");
        HashMap param = Maps.newHashMap();
        param.put("orgNumber", orgNumber);
        param.put("id", id);
        this.getNamedJdbcTemplate().update(sb.toString(), (Map)param);
        StringBuilder sb1 = new StringBuilder("update yunying.tx_message_record set sender_id = null where id >:id and  sender_id = :orgNumber");
        HashMap param1 = Maps.newHashMap();
        param1.put("orgNumber", orgNumber);
        param1.put("id", id);
        this.getNamedJdbcTemplate().update(sb1.toString(), (Map)param1);
    }

    @Override
    public Integer getOrgClueTotal(Long orgNumber) {
        String sql = "select count(*) from yunying.tx_message_record where receiver_role=6 and receiver_id=:receiver_id";
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("receiver_id", orgNumber);
        return this.getNamedJdbcTemplate().queryForInt(sql, param);
    }

    @Override
    public Integer getPeriodOrgClue(Long orgNumber, String startTime, String endTime) {
        String sql = "select count(*) from yunying.tx_message_record where receiver_role=6 and receiver_id=:receiver_id and create_time>=:startTime and create_time<=:endTime";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("receiver_id", orgNumber);
        param.put("startTime", startTime);
        param.put("endTime", endTime);
        return this.getNamedJdbcTemplate().queryForInt(sql, param);
    }

    @Override
    public Integer getOrgWechatClue(Long orgNumber) {
        String sql = "SELECT count(1) FROM yunying.tx_message_record where receiver_role=6 and receiver_id=:receiver_id  and consult_type=2";
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("receiver_id", orgNumber);
        return this.getNamedJdbcTemplate().queryForInt(sql, param);
    }

    @Override
    public Integer getPeriodOrgWechatClue(Long orgNumber, String startTime, String endTime) {
        String sql = "SELECT count(1) FROM yunying.tx_message_record where receiver_role=6 and receiver_id=:receiver_id  and consult_type=2 and create_time>=:startTime and create_time<=:endTime ";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("receiver_id", orgNumber);
        param.put("startTime", startTime);
        param.put("endTime", endTime);
        return this.getNamedJdbcTemplate().queryForInt(sql, param);
    }
}

