/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.push.constant;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;

public enum ConsultType {
    INPUT(0, "\u6765\u8bbf\u54a8\u8be2"),
    TELEPHONE(1, "\u6765\u7535\u54a8\u8be2"),
    WECHAT(2, "\u5fae\u4fe1\u54a8\u8be2"),
    APPOINTMENT(3, "\u9884\u7ea6\u7559\u5355"),
    ONLINE_IM(4, "\u5728\u7ebf\u6d88\u606f"),
    MARKING(5, "\u63a8\u5e7f\u6d88\u606f"),
    SIGNUP(6, "\u6d3b\u52a8\u62a5\u540d"),
    CHOUJIANG(7, "\u62bd\u5956\u6d3b\u52a8");

    private int value;
    private String desc;
    private static List<Integer> noEditConsultType;
    private static Map<Integer, ConsultType> mapping;
    private static Map<Integer, String> originSignConsultMap;

    private ConsultType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static List<Integer> getNoEditConsultType() {
        return noEditConsultType;
    }

    public int getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    public static ConsultType getByType(Integer code) {
        return mapping.get(code);
    }

    public String buildConsultTypeMsg(String msg) {
        String fmt = "%s$%s";
        return String.format(fmt, this.getValue(), msg);
    }

    public static String getOriginSignByType(Integer code) {
        return originSignConsultMap.get(code);
    }

    static {
        noEditConsultType = null;
        mapping = Maps.newHashMap();
        originSignConsultMap = Maps.newHashMap();
        for (ConsultType ct : ConsultType.values()) {
            mapping.put(ct.value, ct);
        }
        noEditConsultType = Lists.newArrayList((Object[])new Integer[]{ConsultType.APPOINTMENT.value, ConsultType.TELEPHONE.value});
        originSignConsultMap.put(ConsultType.TELEPHONE.value, ConsultType.TELEPHONE.desc);
        originSignConsultMap.put(ConsultType.APPOINTMENT.value, ConsultType.APPOINTMENT.desc);
        originSignConsultMap.put(ConsultType.SIGNUP.value, ConsultType.SIGNUP.desc);
        originSignConsultMap.put(ConsultType.CHOUJIANG.value, ConsultType.CHOUJIANG.desc);
    }
}

