/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.baijia.tianxiao.util.query.MapBatchQueryTemplate;
import com.beust.jcommander.internal.Maps;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Repository;

@Repository(value="tianxiao_dal_yunying_orgInfoDao")
public class OrgInfoDaoImpl
extends JdbcTemplateDaoSupport<OrgInfo>
implements OrgInfoDao {
    public OrgInfoDaoImpl() {
        super(OrgInfo.class);
    }

    @Override
    public OrgInfo getOrgInfo(@NonNull Integer orgId, String ... queryProps) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.select(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        return (OrgInfo)this.uniqueResult(builder);
    }

    @Override
    public String getOrgNameByOrgId(Integer orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.select("name");
        builder.eq("orgId", (Serializable)orgId);
        return (String)this.queryForObject(builder, String.class);
    }

    @Override
    public String getOrgShortNameByOrgId(Integer orgId) {
        if (orgId == null) {
            return "";
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.select("shortName");
        builder.eq("orgId", (Serializable)orgId);
        return (String)this.queryForObject(builder, String.class);
    }

    @Override
    public List<OrgInfo> getOrgInfos(Collection<Integer> orgIds, final String ... properties) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return Collections.emptyList();
        }
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        return (List)queryTemplate.batchQuery(orgIds, (BatchQueryCallback)new BatchQueryCallback<Integer, List<OrgInfo>>(){

            public List<OrgInfo> doQuery(Collection<Integer> querySet) {
                SingleSqlBuilder builder = OrgInfoDaoImpl.this.createSqlBuilder(properties);
                builder.in("orgId", querySet);
                return OrgInfoDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public List<OrgInfo> getOrgInfos(Collection<Integer> orgIds, final Integer areaId, final String ... properties) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return Collections.emptyList();
        }
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        return (List)queryTemplate.batchQuery(orgIds, (BatchQueryCallback)new BatchQueryCallback<Integer, List<OrgInfo>>(){

            public List<OrgInfo> doQuery(Collection<Integer> querySet) {
                SingleSqlBuilder builder = OrgInfoDaoImpl.this.createSqlBuilder(properties);
                if (areaId != null) {
                    builder.eq("areaId", (Serializable)areaId);
                }
                builder.in("orgId", querySet);
                return OrgInfoDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public List<Integer> getOrgIdByOrgName(String name) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.select("orgId");
        builder.like("shortName", (Serializable)((Object)name), MatchMode.ANYWHERE);
        return this.queryForList(builder, Integer.class);
    }

    @Override
    public List<OrgInfo> getOrgInfosByExtentions(Collection<String> extensions, final String ... properties) {
        if (CollectionUtils.isEmpty(extensions)) {
            return Collections.emptyList();
        }
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        return (List)queryTemplate.batchQuery(extensions, (BatchQueryCallback)new BatchQueryCallback<String, List<OrgInfo>>(){

            public List<OrgInfo> doQuery(Collection<String> querySet) {
                SingleSqlBuilder builder = OrgInfoDaoImpl.this.createSqlBuilder(properties);
                builder.in("extension", querySet);
                return OrgInfoDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public List<OrgInfo> getOrgInfoByNameAndAreaId(String name, Integer areaId, String ... properties) {
        if (StringUtils.isBlank((CharSequence)name) && areaId == null) {
            return Lists.newArrayList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(properties);
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            builder.like("shortName", (Serializable)((Object)name), MatchMode.ANYWHERE);
        }
        if (areaId != null) {
            builder.eq("areaId", (Serializable)areaId);
        }
        return this.queryList(builder);
    }

    @Override
    public OrgInfo getByExtension(String extension, String ... properties) {
        if (StringUtils.isBlank((CharSequence)extension)) {
            return null;
        }
        SingleSqlBuilder builder = this.createSqlBuilder(properties);
        builder.eq("extension", (Serializable)((Object)extension));
        return (OrgInfo)this.uniqueResult(builder);
    }

    @Override
    public boolean updateMarkingStatusByOrgId(Integer orgId, Integer markingStatus) {
        StringBuilder sb = new StringBuilder();
        sb.append("update yunying.org_info set marketing_status =:markingStatus where org_id = :orgId");
        HashedMap map = new HashedMap();
        map.put("markingStatus", markingStatus);
        map.put("orgId", orgId);
        return this.getNamedJdbcTemplate().update(sb.toString(), (Map)map) > 0;
    }

    @Override
    public Map<Integer, Long> getAreaMap(Collection<Integer> orgIds) {
        return (Map)new MapBatchQueryTemplate().batchQuery(orgIds, (BatchQueryCallback)new BatchQueryCallback<Integer, Map<Integer, Long>>(){

            public Map<Integer, Long> doQuery(Collection<Integer> querySet) {
                SingleSqlBuilder builder = OrgInfoDaoImpl.this.createSqlBuilder(new String[]{"orgId", "areaId"});
                builder.in("orgId", querySet);
                final Map result = Maps.newHashMap();
                OrgInfoDaoImpl.this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        result.put(rs.getInt("orgId"), rs.getLong("areaId"));
                    }
                });
                return result;
            }
        });
    }
}

