/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.activity.dao.impl;

import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.baijia.tianxiao.dal.activity.dao.TemplateTypeDao;
import com.baijia.tianxiao.dal.activity.po.TemplateType;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class TemplateTypeDaoImpl
extends JdbcTemplateDaoSupport<TemplateType>
implements TemplateTypeDao {
    private static final Logger logger = LoggerFactory.getLogger(TemplateTypeDaoImpl.class);

    public TemplateTypeDaoImpl() {
        super(TemplateType.class);
    }

    @Override
    public List<TemplateType> selectTemplateTypeListByCategory(int category) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("category", (Serializable)Integer.valueOf(category));
        return this.queryList(builder);
    }

    @Override
    public Map<Integer, TemplateType> selectTypeByIds(Collection<Integer> typeIds) {
        if (typeIds == null || typeIds.isEmpty()) {
            return Collections.emptyMap();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("typeId", typeIds);
        List types = this.queryList(builder);
        return CollectionUtils.extractMap((Collection)types, (CollectionUtils.Extracter)new CollectionUtils.Extracter<Integer, TemplateType>(){

            public Integer extract(TemplateType templateType) {
                return templateType.getTypeId();
            }
        });
    }
}

