/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.activity.dao.impl;

import com.baijia.tianxiao.dal.activity.dao.ActivityDao;
import com.baijia.tianxiao.dal.activity.po.Activity;
import com.baijia.tianxiao.enums.BlackBoardType;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

@Repository
public class ActivityDaoImpl
extends JdbcTemplateDaoSupport<Activity>
implements ActivityDao {
    private static final Logger logger = LoggerFactory.getLogger(ActivityDaoImpl.class);

    public ActivityDaoImpl() {
        super(Activity.class);
    }

    @Override
    public Long saveActivity(Activity activity) {
        this.save(activity, new String[0]);
        return activity.getId();
    }

    @Override
    public Activity getActivityById(Long id) {
        if (id == null) {
            return null;
        }
        SingleSqlBuilder createSqlBuilder = this.createSqlBuilder(new String[0]);
        createSqlBuilder.eq("id", (Serializable)id);
        List queryList = this.queryList(createSqlBuilder);
        if (GenericsUtils.notNullAndEmpty((Object)queryList)) {
            return (Activity)queryList.get(0);
        }
        return null;
    }

    @Override
    public Activity getActivityByIdAndOrgId(Long id, Long orgId) {
        if (id == null || orgId == null) {
            return null;
        }
        SingleSqlBuilder createSqlBuilder = this.createSqlBuilder(new String[0]);
        createSqlBuilder.eq("id", (Serializable)id);
        createSqlBuilder.eq("orgId", (Serializable)orgId);
        List queryList = this.queryList(createSqlBuilder);
        if (GenericsUtils.notNullAndEmpty((Object)queryList)) {
            return (Activity)queryList.get(0);
        }
        return null;
    }

    @Override
    public void update(Activity activity) {
        super.update((Object)activity, new String[0]);
    }

    @Override
    public List<Activity> listActivities(Integer status, Long lastId, Integer orgId, PageDto pageDto) {
        HashMap<String, Number> paramMap = new HashMap<String, Number>();
        paramMap.put("id", lastId);
        paramMap.put("orgId", orgId);
        paramMap.put("firstIndex", (pageDto.getPageNum() - 1) * pageDto.getPageSize());
        paramMap.put("pageSize", pageDto.getPageSize());
        paramMap.put("bType", BlackBoardType.NOTICE.getType());
        paramMap.put("cType", 9);
        String sql = "select * from yunying.org_blackboard_info o1, (select update_time from yunying.org_blackboard_info where id = :id) o2  where bb_type = :bType and c_type=:cType and o1.org_id =:orgId  and (o1.update_time < o2.update_time or (o1.update_time = o2.update_time and o1.id < :id))  order by o1.update_time desc,o1.id desc limit :firstIndex,:pageSize";
        if (lastId == null || lastId == 0L) {
            sql = "select * from yunying.org_blackboard_info where bb_type = :bType and c_type=:cType and org_id = :orgId order by update_time desc , id desc limit :firstIndex,:pageSize ";
            paramMap.remove("id");
        }
        return (List)this.getNamedJdbcTemplate().query(sql, paramMap, (ResultSetExtractor)new ResultSetExtractor<List<Activity>>(){

            public List<Activity> extractData(ResultSet rs) throws SQLException, DataAccessException {
                ArrayList<Activity> activitys = new ArrayList<Activity>();
                while (rs.next()) {
                    activitys.add(this.toActivity(rs));
                }
                return activitys;
            }

            private Activity toActivity(ResultSet rs) throws SQLException {
                Activity activity = new Activity();
                activity.setId(rs.getLong("id"));
                activity.setContent(rs.getString("content"));
                activity.setBbType(rs.getInt("bb_type"));
                activity.setCreateTime(rs.getString("create_time"));
                activity.setcType(rs.getInt("c_type"));
                activity.setTitle(rs.getString("title"));
                activity.setUpdateTime(rs.getString("update_time"));
                activity.setOrgId(rs.getInt("org_id"));
                activity.setSwitcher(rs.getInt("switcher"));
                activity.setSupportNum(rs.getInt("support_num"));
                activity.setQrUrl(rs.getString("qr_url"));
                activity.setIsdel(rs.getInt("isdel"));
                activity.setrType(rs.getInt("r_type"));
                return activity;
            }
        });
    }

    @Override
    public Activity getActivityByIdAndOrgId(Long id, Integer orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("id", (Serializable)id);
        if (orgId != null) {
            builder.eq("orgId", (Serializable)orgId);
        }
        return (Activity)this.uniqueResult(builder);
    }

    @Override
    public Integer getPeriodActivitys(Integer orgId, String startDate, String endDate) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("bbType", (Serializable)Integer.valueOf(BlackBoardType.NOTICE.getType()));
        builder.eq("cType", (Serializable)Integer.valueOf(9));
        builder.between("createTime", (Comparable)((Object)startDate), (Comparable)((Object)endDate));
        builder.count("id");
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public List<Activity> getActivitys(Integer orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("bbType", (Serializable)Integer.valueOf(BlackBoardType.NOTICE.getType()));
        builder.eq("cType", (Serializable)Integer.valueOf(9));
        builder.count("id");
        return this.queryList(builder);
    }
}

