/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.wechat.dao.impl;

import com.baijia.tianxiao.dal.wechat.dao.OrgWechatMediaNewsDao;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatMediaNews;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class OrgWechatMediaNewsDaoImpl
extends JdbcTemplateDaoSupport<OrgWechatMediaNews>
implements OrgWechatMediaNewsDao {
    public OrgWechatMediaNewsDaoImpl() {
        super(OrgWechatMediaNews.class);
    }

    @Override
    public OrgWechatMediaNews getByMediaId(String authorizerAppId, String mediaId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("authorizerAppId", (Serializable)((Object)authorizerAppId));
        builder.eq("mediaId", (Serializable)((Object)mediaId));
        return (OrgWechatMediaNews)this.uniqueResult(builder);
    }

    @Override
    public void updateByMediaId(OrgWechatMediaNews mediaNews) {
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        StringBuilder builder = new StringBuilder();
        builder.append(" UPDATE yunying.org_wechat_media_news SET");
        builder.append("   json=:json");
        builder.append("   wechat_update_time=:wechatUpdateTime");
        builder.append("   update_time=:updateTime");
        builder.append(" WHERE authorizer_app_id=:authorizerAppId");
        builder.append(" AND media_id=:mediaId");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("json", mediaNews.getJson());
        params.put("wechatUpdateTime", mediaNews.getWechatUpdateTime());
        params.put("updateTime", new Date());
        params.put("authorizerAppId", mediaNews.getAuthorizerAppId());
        params.put("mediaId", mediaNews.getMediaId());
        template.update(builder.toString(), params);
    }

    @Override
    public void delByMediaIds(String authorizerAppId, List<String> mediaIds) {
        if (mediaIds == null || mediaIds.isEmpty()) {
            return;
        }
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        String sql = "DELETE FROM yunying.org_wechat_media_news WHERE authorizer_app_id=:authorizerAppId AND media_id IN (:mediaIds)";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("authorizerAppId", authorizerAppId);
        params.put("mediaIds", mediaIds);
        template.update(sql, params);
    }

    @Override
    public Map<String, Date> mapKeyMediaIdValueWechatUpdateTime(String authorizerAppId) {
        final HashMap<String, Date> map = new HashMap<String, Date>();
        String sql = "SELECT media_id,wechat_update_time FROM yunying.org_wechat_media_news WHERE authorizer_app_id=:authorizerAppId";
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("authorizerAppId", authorizerAppId);
        template.query(sql, params, (RowMapper)new RowMapper<Integer>(){

            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                map.put(rs.getString("media_id"), rs.getTimestamp("wechat_update_time"));
                return 1;
            }
        });
        return map;
    }

    @Override
    public int count(String authorizerAppId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("authorizerAppId", (Serializable)((Object)authorizerAppId));
        builder.count("id");
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public List<OrgWechatMediaNews> search(String authorizerAppId, PageDto pageDto) {
        final ArrayList<OrgWechatMediaNews> list = new ArrayList<OrgWechatMediaNews>();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT * FROM yunying.org_wechat_media_news WHERE authorizer_app_id=:authorizerAppId ");
        builder.append(" ORDER BY wechat_update_time DESC");
        if (pageDto != null) {
            builder.append(" LIMIT :start,:size");
        }
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("authorizerAppId", authorizerAppId);
        if (pageDto != null) {
            params.put("start", pageDto.firstNum());
            params.put("size", pageDto.getPageSize());
        }
        template.query(builder.toString(), params, (RowMapper)new RowMapper<Integer>(){
            OrgWechatMediaNews mediaNews;

            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                this.mediaNews = new OrgWechatMediaNews();
                this.mediaNews.setId(rs.getInt("id"));
                this.mediaNews.setAuthorizerAppId(rs.getString("authorizer_app_id"));
                this.mediaNews.setMediaId(rs.getString("media_id"));
                this.mediaNews.setJson(rs.getString("json"));
                this.mediaNews.setWechatUpdateTime(rs.getTimestamp("wechat_update_time"));
                this.mediaNews.setUpdateTime(rs.getTimestamp("update_time"));
                this.mediaNews.setCreateTime(rs.getTimestamp("create_time"));
                list.add(this.mediaNews);
                return 1;
            }
        });
        return list;
    }
}

