/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.roster.dao.impl;

import com.baijia.tianxiao.dal.org.constant.StudentType;
import com.baijia.tianxiao.dal.roster.dao.TxStudentTagDao;
import com.baijia.tianxiao.dal.roster.po.TxStudentTag;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository
public class TxStudentTagDaoImpl
extends JdbcTemplateDaoSupport<TxStudentTag>
implements TxStudentTagDao {
    public TxStudentTagDaoImpl() {
        super(TxStudentTag.class);
    }

    @Override
    public List<TxStudentTag> getTags(Long studentId, Long orgId, Integer type, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        if (type.intValue() == StudentType.CONSULT_USER.getCode()) {
            builder.eq("consultUserId", (Serializable)studentId);
        } else {
            builder.eq("userId", (Serializable)studentId);
            builder.eq("orgId", (Serializable)orgId);
        }
        builder.desc("createTime");
        return this.queryList(builder);
    }

    @Override
    public void updateTag(Long consultUserId, Long userId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("consultUserId", (Serializable)consultUserId);
        HashMap params = Maps.newHashMap();
        params.put("userId", userId);
        params.putAll(builder.collectConditionValue());
        this.getNamedJdbcTemplate().update(builder.toUpdateSql(new String[]{"userId"}), (Map)params);
    }

    @Override
    public void delTags(Long userId, Long orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("userId", (Serializable)userId);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("consultUserId", (Serializable)Integer.valueOf(0));
        this.getNamedJdbcTemplate().update(builder.toDeleteSqlByCondition(), builder.collectConditionValue());
    }

    @Override
    public Map<String, TxStudentTag> getAndCachedTags(Long studentId, Long orgId, Integer type) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (type.intValue() == StudentType.CONSULT_USER.getCode()) {
            builder.eq("consultUserId", (Serializable)studentId);
        } else {
            builder.eq("userId", (Serializable)studentId);
            builder.eq("orgId", (Serializable)orgId);
        }
        builder.desc("createTime");
        List result = this.queryList(builder);
        if (result != null && !result.isEmpty()) {
            HashMap ret = Maps.newHashMap();
            for (TxStudentTag tag : result) {
                ret.put(tag.getContent(), tag);
            }
            return ret;
        }
        return Collections.emptyMap();
    }
}

