/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgGroupMsgReceiverDao;
import com.baijia.tianxiao.dal.org.po.OrgGroupMsgReceiver;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Repository;

@Repository
public class OrgGroupMsgReceiverDaoImpl
extends JdbcTemplateDaoSupport<OrgGroupMsgReceiver>
implements OrgGroupMsgReceiverDao {
    public OrgGroupMsgReceiverDaoImpl() {
        super(OrgGroupMsgReceiver.class);
    }

    @Override
    public List<OrgGroupMsgReceiver> queryReceivers(Long orgId, Long msgId, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("msgId", (Serializable)msgId);
        return this.queryList(builder);
    }

    @Override
    public Map<Long, Integer> queryRecievedCountMap(Long orgId, Boolean viewStatus, Collection<Long> msgIds) {
        if (CollectionUtils.isEmpty(msgIds)) {
            return Maps.newHashMap();
        }
        HashMap params = Maps.newHashMap();
        StringBuffer sql = new StringBuffer();
        sql.append("select received.msg_id, count(1) as num from yunying.org_group_msg_received received where received.org_id =:orgId and received.msg_id in (:msgId) ");
        if (viewStatus != null) {
            sql.append("and received.view_status =:viewStatus ");
            params.put("viewStatus", viewStatus);
        }
        sql.append("group by received.msg_id");
        params.put("orgId", orgId);
        params.put("msgId", msgIds);
        final HashMap result = Maps.newHashMap();
        this.getNamedJdbcTemplate().query(sql.toString(), (Map)params, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                result.put(rs.getLong("msgId"), rs.getInt("num"));
            }
        });
        return result;
    }

    @Override
    public OrgGroupMsgReceiver queryReceiver(Long orgId, Long msgId, Long receiverId, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("msgId", (Serializable)msgId);
        builder.eq("receiverId", (Serializable)receiverId);
        return (OrgGroupMsgReceiver)this.uniqueResult(builder);
    }
}

