/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.activity.dao.referral.impl;

import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.baijia.tianxiao.dal.activity.dao.referral.GiftInfoDao;
import com.baijia.tianxiao.dal.activity.po.referral.GiftInfo;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository
public class GiftInfoDaoImpl
extends JdbcTemplateDaoSupport<GiftInfo>
implements GiftInfoDao {
    @Override
    public Long insertGiftInfo(GiftInfo gi) {
        this.save(gi, new String[0]);
        return gi.getId();
    }

    @Override
    public GiftInfo selectGiftById(long giftId) {
        return (GiftInfo)this.getById(Long.valueOf(giftId), new String[0]);
    }

    @Override
    public void deleteGifts(Long activityId, List<Long> gifts) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder("update yunying.tx_activity_referral_gift set status = 0 where activity_id = :activityId ");
        if (GenericsUtils.notNullAndEmpty(gifts)) {
            sql.append(" and id not in(:gifts)");
            paramMap.put("gifts", gifts);
        }
        paramMap.put("activityId", activityId);
        this.getNamedJdbcTemplate().update(sql.toString(), paramMap);
    }

    @Override
    public List<GiftInfo> selectGifts(Long activityId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("activity_id", (Serializable)activityId);
        List giftInfos = this.queryList(builder);
        return GenericsUtils.isNullOrEmpty((Object)giftInfos) ? Collections.emptyList() : giftInfos;
    }

    @Override
    public void updateGifts(List<GiftInfo> gifts) {
        if (GenericsUtils.isNullOrEmpty(gifts)) {
            return;
        }
        for (GiftInfo giftInfo : gifts) {
            this.saveOrUpdate(giftInfo, new String[0]);
        }
    }

    @Override
    public Map<Long, GiftInfo> selectGiftByIds(List<Long> giftIds) {
        SingleSqlBuilder bulder = this.createSqlBuilder(new String[0]);
        bulder.in("id", giftIds);
        List queryList = this.queryList(bulder);
        return CollectionUtils.extractMap((Collection)queryList, (CollectionUtils.Extracter)new CollectionUtils.Extracter<Long, GiftInfo>(){

            public Long extract(GiftInfo arg0) {
                return arg0.getId();
            }
        });
    }
}

