package com.baijia.tianxiao.dal.org.po;

import java.math.BigDecimal;

/**
 * Created by liuxp on 16/8/3.
 */
public class OrgStudentLessonCounter {
    private final static String PREFIX = "stu_lesson_";
    private final static String SEPARATOR = "_";

    private String id;

    private long userId;

    private long orgId;

    private long courseId;

    private long totalCount;

    private long finishedCount;

    private long leftCount;

    private BigDecimal leftCountRatio;// 剩余课时/总排课课时

    public String getId() {
        StringBuilder sb = new StringBuilder();
        sb.append(PREFIX).append(userId).append(SEPARATOR).append(courseId);
        return sb.toString();
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getUserId() {
        return userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public long getCourseId() {
        return courseId;
    }

    public void setCourseId(long courseId) {
        this.courseId = courseId;
    }

    public long getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    public long getFinishedCount() {
        return finishedCount;
    }

    public void setFinishedCount(long finishedCount) {
        this.finishedCount = finishedCount;
    }

    public long getLeftCount() {
        return totalCount-finishedCount;
    }

    public void setLeftCount(long leftCount) {
        this.leftCount = leftCount;
    }

    public long getOrgId() {
        return orgId;
    }

    public void setOrgId(long orgId) {
        this.orgId = orgId;
    }

    public BigDecimal getLeftCountRatio() {
        BigDecimal total = new BigDecimal(totalCount);
        BigDecimal left = new BigDecimal(getLeftCount());
        if (getLeftCount() <= 0) {
            return BigDecimal.ZERO;
        }
        if(totalCount<=0){
            return BigDecimal.ZERO;
        }
        return left.divide(total, 2, BigDecimal.ROUND_HALF_EVEN);
    }
}
