
package com.baijia.tianxiao.dal.org.po;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;
import java.util.Date;
import lombok.Data;

/**
 * @title OrgStudentCourse
 * @desc 机构课程学生关联表
 * @author shanyu
 * @date 2015年10月12日
 * @version 1.0
 */

@Entity(dataSourceBeanName = "ttsDataSource")
@Table(name = "org_student_course", catalog = "tts")
@Data
public class OrgStudentCourse {
    @Id
    @GeneratedValue
    private Long id;

    @Column
    private Long orgId;

    @Column
    private Long courseId;

    @Column(name = "student_id")
    private Long userId;

    @Column
    private String studentName;

    @Column
    private String studentMobile;

    @Column
    private Date createTime;

    @Column
    private Integer delStatus;

    @Column
    private int tradeComplete;

    /**
     * 0:正常，1：已经退班，2已经转班
     */
    @Column
    private Integer status;
}
