/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.TtsSmsDao;
import com.baijia.tianxiao.dal.org.po.TtsSms;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author cxm
 * @version 1.0
 * @title TtsSmsDaoImpl
 * @desc TODO
 * @date 2015年10月26日
 */
@Repository
public class TtsSmsDaoImpl extends JdbcTemplateDaoSupport<TtsSms> implements TtsSmsDao {

    public TtsSmsDaoImpl() {
        super(TtsSms.class);
    }

    @Override
    public Integer getTtsSmsTotal(Integer orgId, Integer userRole, Integer sendResult, String startDate,
        String endDate) {
        SingleSqlBuilder<TtsSms> builder = createSqlBuilder();
        builder.eq("userId", orgId);
        if (userRole != null) {
            builder.eq("userRole", userRole);
        }
        if (sendResult != null) {
            builder.eq("sendResult", sendResult);
        }
        if (startDate != null && endDate != null) {
            builder.between("createTime", startDate, endDate);
        }
        builder.count("id");
        return queryForObject(builder, Integer.class);
    }

    @Override
    public Map<Long, Integer> getOrgTtsSmsCount(Date startTime, Date endTime, List<Long> TianxiaoOrgIds) {
        String sql =
            "select count(1) as count,user_id as org_id from tts.tts_sms where user_role = 6 and user_id in (:orgIds)";
        Map<String, Object> param = new HashMap<>();
        param.put("orgIds", TianxiaoOrgIds);
        if (startTime != null && endTime != null) {
            sql += " and create_time between :startDate and :endDate";
            param.put("startDate", startTime);
            param.put("endDate", endTime);
        }
        sql += " GROUP BY user_id";
        return this.getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<Map<Long, Integer>>() {

            @Override
            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                Map<Long, Integer> map = new HashMap<>();
                while (rs.next()) {
                    Long orgId = rs.getLong("org_id");
                    Integer count = rs.getInt("count");
                    map.put(orgId, count);
                }
                return map;
            }
        });
    }
}
