
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgClassRoomDao;
import com.baijia.tianxiao.dal.org.po.OrgClassRoom;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.MapBatchQueryTemplate;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @title OrgClassRoomDaoImpl
 * @desc TODO
 * @author cxm
 * @date 2015年12月24日
 * @version 1.0
 */
@Repository
public class OrgClassRoomDaoImpl extends JdbcTemplateDaoSupport<OrgClassRoom> implements OrgClassRoomDao {

    public OrgClassRoomDaoImpl() {
        super(OrgClassRoom.class);
    }

    @Override
    public List<OrgClassRoom> getClassRoom(Long orgId, Long branchId, Boolean isDel, PageDto page,
        String...queryProps) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgid is illegal");
        SingleSqlBuilder<OrgClassRoom> builder = createSqlBuilder(queryProps);
        builder.eq("orgId", orgId);
        if (branchId != null) {
            builder.eq("branchId", branchId);
        }
        if (isDel != null) {
            builder.eq("delStatus", isDel);
        }
        builder.desc("createTime");
        builder.setPage(page);
        return queryList(builder);

    }

    @Override
    public Map<Long, String> getRoomName(final Long orgId, Collection<Long> roomIds) {
        if (CollectionUtils.isEmpty(roomIds)) {
            return Maps.newHashMap();
        }
        return new MapBatchQueryTemplate<Long, Long, String>().batchQuery(roomIds,
            new BatchQueryCallback<Long, Map<Long, String>>() {

                @Override
                public Map<Long, String> doQuery(Collection<Long> querySet) {
                    SingleSqlBuilder<OrgClassRoom> builder = createSqlBuilder("roomName", "id");
                    if (orgId != null) {
                        builder.eq("orgId", orgId);
                    }
                    builder.in("id", querySet);
                    final Map<Long, String> result = Maps.newHashMap();
                    getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(),
                        new RowCallbackHandler() {
                        @Override
                        public void processRow(ResultSet rs) throws SQLException {
                            result.put(rs.getLong("id"), rs.getString("roomName"));
                        }
                    });
                    return result;
                }
            });
    }


    @Override
    public void refreshClassRoom(Long orgId, Long id) {
        StringBuilder sb = new StringBuilder("update tts.org_class_room set del_status =1 where id > :id and  org_id = :orgId");
        Map param = Maps.newHashMap();
        param.put("orgId", orgId);
        param.put("id", id);
        this.getNamedJdbcTemplate().update(sb.toString(), param);
    }
    
    @Override
    public List<OrgClassRoom> getOrgClassRoomListByRoomIds(Collection<Long> roomIds) {
        SingleSqlBuilder<OrgClassRoom> builder = createSqlBuilder();
        builder.in("id", roomIds);
        return queryList(builder);
    }
}
