
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.dao;

import com.baijia.tianxiao.dal.org.po.OrgCourseSms;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @title OrgCourseSmsDao
 * @desc TODO
 * @author shanyu
 * @date 2015年12月25日
 * @version 1.0
 */

public interface OrgCourseSmsDao extends CommonDao<OrgCourseSms> {

    /**
     * 获取课表短信发送状态
     * 
     * @param orgId
     * @param courseId
     * @param userRole
     * @return
     */
    public List<OrgCourseSms> getOrgCourseSmsList(Long orgId, Long courseId, Integer userRole, String...queryProps);

    /**
     * 获取课表短信发送状态
     * 
     * @param orgId
     * @param courseId
     * @return
     */
    public List<OrgCourseSms> getOrgCourseSmsList(Long orgId, Collection<Long> courseIds, Integer userRole,
        String...queryProps);

    public OrgCourseSms getOrgCourseSms(Long orgId, Long courseId, Integer userRole, Long userId, String...queryProps);

    public void increaseSendTime(Long orgId, Long courseId, Integer userRole, Long userId);

    public void setViewStatus(Long id, Integer viewStatus);

    /**
     * 删除短信记录
     * 
     * @param orgId
     * @param courseId
     * @param userRole
     * @param userId
     */
    void delCourseSmsRecord(Long orgId, Long courseId, Integer userRole, Collection<Long> userIds);

    /**
     * 获取机构发送课表数量
     */
    public Map<Long, Integer> courseSmsTotal(Date startTime, Date endTime, List<Long> TianxiaoOrgIds);
}
