
package com.baijia.tianxiao.dal.org.dao;

import com.baijia.tianxiao.dal.org.po.OrgCourseRoom;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface OrgCourseRoomDao extends CommonDao<OrgCourseRoom> {

    /**
     * 根据课程ID查询课程对应教室列表
     * 
     * @param orgId
     * @param courseId
     * @param queryProps
     * @return
     */
    List<OrgCourseRoom> getCourseRoomList(Long orgId, Long courseId, String...queryProps);

    /**
     * 批量查询多个课程对应的教室列表
     * 
     * @param orgId
     * @param courseIds
     * @param queryProps
     * @return
     */
    Map<Long, List<OrgCourseRoom>> getCourseRoomMap(Long orgId, Collection<Long> courseIds, String...queryProps);

    /**
     * 获取课程教室数量
     * 
     * @param orgId
     * @param courseIds
     * @return
     */
    Map<Long, Integer> getCourseRoomCount(Long orgId, Collection<Long> courseIds);

    /**
     * 根据课程ID查找默认教室
     * 
     * @param orgId
     * @param courseId
     * @param queryProps
     * @return
     */
    OrgCourseRoom getCourseDefaultRoom(Long orgId, Long courseId, String...queryProps);

    List<OrgCourseRoom> getCourseDefaultRoom(Long orgId, Collection<Long> courseId, String...queryProps);

    /**
     * 设置机构知道课程的默认教室
     * 
     * @param orgId
     * @param courseId
     * @param roomId
     * @param enable true 启用, false 禁用
     */
    void courseDefaultRoomSet(Long orgId, Long courseId, Long roomId, boolean enable);

    /**
     * @param orgId
     * @param courseId
     * @param roomIds
     * @return
     */
    int delCourseRoom(Long orgId, Long courseId, Collection<Long> roomIds);

    /**
     * @param orgId
     * @param courseId
     * @return
     */
    List<Long> getCourseRoomIds(Long orgId, Long courseId);

    /**
     * 获取机构教室数量
     * @param orgId
     * @param startDate 开始时间 不是null获取机构在某段时间教室数量
     * @param endDate 结束时间
     * @return
     */
    Map<Long,Integer> getOrgRoomTotal();


    List<Long> getcoursIdsByRoomIds(Collection<Long> roomIds);
    
}
