
package com.baijia.tianxiao.dal.org.dao;

import com.baijia.tianxiao.dal.org.po.OrgClassRoom;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface OrgClassRoomDao extends CommonDao<OrgClassRoom> {

    /**
     * 获取机构校区的教室列表
     * 
     * @param orgId
     * @param branchId 校区ID不指定就查询整个机构的教室列表
     * @return
     */
    List<OrgClassRoom> getClassRoom(Long orgId, Long branchId, Boolean isDel, PageDto page, String...queryProps);

    /**
     * 获取教室名
     * 
     * @param orgId
     * @param roomIds
     * @return
     */
    Map<Long, String> getRoomName(Long orgId, Collection<Long> roomIds);


    void refreshClassRoom(Long orgId, Long id);
    
    /**
     * 根据roomIds获取教室信息
     * 
     */
    List<OrgClassRoom> getOrgClassRoomListByRoomIds(Collection<Long> roomIds);

    /**
     * 根据教室ID集合和教室名称查询教室列表
     * @param roomIds
     * @param query
     * @return
     */
    List<OrgClassRoom> getOrgClassRoomByNameAndIds(Long orgId, Collection<Long> roomIds, String query);
    
    /**
     * 根据查询字符串查询教室信息
     * @param orgId：机构id
     * @param pageDto：页面信息
     * @param key：查询字符串
     * @param orgCourseRoomIds：已选的教室id集合
     */
	 List<OrgClassRoom> queryListByParam(Long orgId, String key, Collection<Long> orgCourseRoomIds, PageDto pageDto);
}
