
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.constant;

import java.util.HashMap;
import java.util.Map;

/**
 * @title SignStatus
 * @desc 签到状态
 * @author shanyu
 * @date 2015年12月30日
 * @version 1.0
 */

public enum SignStatus {
	
    UNSIGN(0, "未签到"),

    SIGNED(1, "到课"),

    LEAVE(2, "请假"),

    ABSENT(3, "缺课"),
    ;
    private int code;

    private String message;

    private static Map<Integer, SignStatus> map;

    private SignStatus(int code, String message) {
        this.code = code;
        this.message = message;
    }

    static {
        map = new HashMap<>();
        for (SignStatus status : SignStatus.values()) {
            map.put(status.code, status);
        }
    }

    public int getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

    public static SignStatus getSignStatusByCode(Integer code) {
        return map.get(code);
    }
}
