/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dto.DeleteStatus;
import com.baijia.tianxiao.dal.org.dto.StudentClasHourDocument;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dal.org.po.StudentLessonStatistics;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.TupleUtil;
import com.baijia.tianxiao.util.TwoTuple;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.baijia.tianxiao.util.query.MapBatchQueryTemplate;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class OrgStudentLessonDaoImpl
extends JdbcTemplateDaoSupport<OrgStudentLesson>
implements OrgStudentLessonDao {
    private static final Logger log = LoggerFactory.getLogger(OrgStudentLessonDaoImpl.class);

    public OrgStudentLessonDaoImpl() {
        super(OrgStudentLesson.class);
    }

    @Override
    public void delStudentFromLesson(Long orgId, Collection<Long> lessonIds, Long userId) {
        if (CollectionUtils.isEmpty(lessonIds)) {
            log.info("lessonIds = {}", lessonIds);
            return;
        }
        String sql = "update tts.org_student_lesson set del_status=1 where org_id=:orgId and lesson_id in (:lessonId) and student_id = :userId";
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("lessonId", lessonIds);
        condition.put("userId", userId);
        this.getNamedJdbcTemplate().update(sql, (Map)condition);
    }

    @Override
    public void delStudentsFromLesson(Long lessonId, Collection<Long> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            log.info("lessonIds = {}", userIds);
            return;
        }
        String sql = "update tts.org_student_lesson set del_status=1 where lesson_id=:lessonId and student_id in (:userIds)";
        HashMap condition = Maps.newHashMap();
        condition.put("lessonId", lessonId);
        condition.put("userIds", userIds);
        this.getNamedJdbcTemplate().update(sql, (Map)condition);
    }

    @Override
    public int delStudentFromLesson(Long orgId, Collection<Long> lessonIds, Collection<Long> userIds) {
        if (CollectionUtils.isEmpty(lessonIds)) {
            log.info("lessonIds = {}", lessonIds);
            return 0;
        }
        String sql = "update tts.org_student_lesson set del_status=1 where org_id=:orgId and lesson_id in (:lessonId)";
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("lessonId", lessonIds);
        if (!CollectionUtils.isEmpty(userIds)) {
            sql = sql + " and student_id in (:userId)";
            condition.put("userId", userIds);
        }
        return this.getNamedJdbcTemplate().update(sql, (Map)condition);
    }

    @Override
    public List<Long> getLessIdsOfStudent(final Long orgId, Collection<Long> lessonIds, final Long userId) {
        if (CollectionUtils.isEmpty(lessonIds)) {
            log.info("lessonIds = {}", lessonIds);
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate batch = new ListBatchQueryTemplate();
        return (List)batch.batchQuery(lessonIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<Long>>(){

            public List<Long> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentLessonDaoImpl.this.createSqlBuilder(new String[]{"lessonId"});
                builder.in("lessonId", querySet);
                builder.eq("userId", (Serializable)userId);
                builder.eq("orgId", (Serializable)orgId);
                builder.eq("delStatus", (Serializable)Integer.valueOf(0));
                return OrgStudentLessonDaoImpl.this.queryForList(builder, Long.class);
            }
        });
    }

    @Override
    public List<Long> getUserIds(Long lessonId, Long orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"userId"});
        builder.eq("lessonId", (Serializable)lessonId);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        return this.queryForList(builder, Long.class);
    }

    @Override
    public Map<Long, List<Long>> getStudentCount(Collection<Long> lessonIds, final Long orgId) {
        if (CollectionUtils.isEmpty(lessonIds)) {
            log.info("lessonIds = {}", lessonIds);
            return Maps.newHashMap();
        }
        ListBatchQueryTemplate batch = new ListBatchQueryTemplate();
        List list = (List)batch.batchQuery(lessonIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgStudentLesson>>(){

            public List<OrgStudentLesson> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentLessonDaoImpl.this.createSqlBuilder(new String[]{"lessonId"});
                builder.in("lessonId", querySet);
                builder.eq("orgId", (Serializable)orgId);
                builder.eq("delStatus", (Serializable)Integer.valueOf(0));
                return OrgStudentLessonDaoImpl.this.queryList(builder);
            }
        });
        return CollectorUtil.group((Collection)list, (Function)new Function<OrgStudentLesson, Long>(){

            public Long apply(OrgStudentLesson arg0) {
                return arg0.getLessonId();
            }
        }, (Function)new Function<OrgStudentLesson, Long>(){

            public Long apply(OrgStudentLesson arg0) {
                return arg0.getUserId();
            }
        });
    }

    @Override
    public Map<Long, List<Long>> getLessonIdsOfStudents(final Long orgId, Collection<Long> userIds, final Collection<Long> lessonIds) {
        if (CollectionUtils.isEmpty(userIds) || CollectionUtils.isEmpty(lessonIds)) {
            log.info("userIds = {} lessonIds={}", userIds, lessonIds);
            return Maps.newHashMap();
        }
        ListBatchQueryTemplate batch = new ListBatchQueryTemplate();
        List list = (List)batch.batchQuery(userIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgStudentLesson>>(){

            public List<OrgStudentLesson> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentLessonDaoImpl.this.createSqlBuilder(new String[]{"userId", "lessonId"});
                builder.in("userId", querySet);
                if (lessonIds != null) {
                    builder.in("lessonId", lessonIds);
                }
                builder.eq("orgId", (Serializable)orgId);
                builder.eq("delStatus", (Serializable)Integer.valueOf(0));
                return OrgStudentLessonDaoImpl.this.queryList(builder);
            }
        });
        return CollectorUtil.group((Collection)list, (Function)new Function<OrgStudentLesson, Long>(){

            public Long apply(OrgStudentLesson arg0) {
                return arg0.getUserId();
            }
        }, (Function)new Function<OrgStudentLesson, Long>(){

            public Long apply(OrgStudentLesson arg0) {
                return arg0.getLessonId();
            }
        });
    }

    @Override
    public List<OrgStudentLesson> getLessonsOfStudent(Long orgId, Long userId, Collection<Long> lessonIds) {
        if (CollectionUtils.isEmpty(lessonIds) || CollectionUtils.isEmpty(lessonIds)) {
            log.info("lessonIds = {}", lessonIds);
            return Lists.newArrayList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("lessonId", lessonIds);
        builder.eq("userId", (Serializable)userId);
        builder.eq("orgId", (Serializable)orgId);
        return this.queryList(builder);
    }

    @Override
    public Map<Long, Integer> queryLessonStudentCountMap(final Long orgId, Collection<Long> lessonIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        if (CollectionUtils.isEmpty(lessonIds)) {
            return Collections.emptyMap();
        }
        return (Map)new MapBatchQueryTemplate().batchQuery(lessonIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, Integer>>(){

            public Map<Long, Integer> doQuery(Collection<Long> lessonIds) {
                SingleSqlBuilder builder = OrgStudentLessonDaoImpl.this.createSqlBuilder(new String[0]);
                builder.distinctCount("userId", "studentCount");
                builder.eq("orgId", (Serializable)orgId);
                builder.in("lessonId", lessonIds);
                builder.eq("delStatus", (Serializable)Integer.valueOf(0));
                builder.group("lessonId");
                final HashMap result = Maps.newHashMap();
                log.debug("query lesson student count sql:{} params:{}", (Object)builder.toSql(), (Object)builder.collectConditionValue());
                OrgStudentLessonDaoImpl.this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        result.put(rs.getLong("lessonId"), rs.getInt("studentCount"));
                    }
                });
                return result;
            }
        });
    }

    @Override
    public Map<Long, Integer> queryLessonStudentCountMap(final Long orgId, Collection<Long> lessonIds, final Collection<Integer> lessonTypes) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        if (CollectionUtils.isEmpty(lessonIds)) {
            return Collections.emptyMap();
        }
        return (Map)new MapBatchQueryTemplate().batchQuery(lessonIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, Integer>>(){

            public Map<Long, Integer> doQuery(Collection<Long> lessonIds) {
                SingleSqlBuilder builder = OrgStudentLessonDaoImpl.this.createSqlBuilder(new String[0]);
                builder.distinctCount("userId", "studentCount");
                builder.eq("orgId", (Serializable)orgId);
                builder.in("lessonId", lessonIds);
                builder.in("lessonType", lessonTypes);
                builder.eq("delStatus", (Serializable)Integer.valueOf(0));
                builder.group("lessonId");
                final HashMap result = Maps.newHashMap();
                log.debug("query lesson student count sql:{} params:{}", (Object)builder.toSql(), (Object)builder.collectConditionValue());
                OrgStudentLessonDaoImpl.this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        result.put(rs.getLong("lessonId"), rs.getInt("studentCount"));
                    }
                });
                return result;
            }
        });
    }

    @Override
    public Integer queryLessonStudentCount(Long orgId, Long lessonId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.distinctCount("userId", "studentCount");
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("lessonId", (Serializable)lessonId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public Integer queryLessonStudentCount(Long orgId, Collection<Long> lessonIds) {
        if (CollectionUtils.isEmpty(lessonIds)) {
            return 0;
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("orgId", (Serializable)orgId);
        builder.in("lessonId", lessonIds);
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public List<Long> getLessonIdsOfStudent(Long orgId, Long userId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"lessonId"});
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("userId", (Serializable)userId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        return this.queryForList(builder, Long.class);
    }

    @Override
    public Integer getStudentLessonCountToday(Long orgId, Long userId) {
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("orgId", orgId);
        paramMap.put("userId", userId);
        paramMap.put("startTime", DateUtil.getCurrentDate());
        paramMap.put("endTime", DateUtil.getDayDiff((int)1));
        String sql = "select count(ocl.id) from tts.org_student_lesson osl join tts.org_class_lesson ocl on osl.lesson_id = ocl.id where ocl.org_id = :orgId AND ocl.start_time > :startTime AND ocl.end_time <= :endTime AND osl.student_id = :userId AND ocl.del_status=0 and osl.del_status = 0 ";
        return (Integer)this.getNamedJdbcTemplate().queryForObject(sql, (Map)paramMap, Integer.class);
    }

    @Override
    public Integer getStudentLessonCountTodayByCourseId(Long orgId, Long userId, List<Long> courseIds) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return 0;
        }
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("orgId", orgId);
        paramMap.put("userId", userId);
        paramMap.put("courseIds", courseIds);
        paramMap.put("startTime", DateUtil.getCurrentDate());
        paramMap.put("endTime", DateUtil.getDayDiff((int)1));
        String sql = "select count(ocl.id) from tts.org_student_lesson osl join tts.org_class_lesson ocl on osl.lesson_id = ocl.id where ocl.org_id = :orgId AND ocl.start_time > :startTime AND ocl.end_time <= :endTime AND osl.student_id = :userId AND ocl.del_status=0 and osl.del_status = 0 and ocl.course_id IN (:courseIds )";
        return (Integer)this.getNamedJdbcTemplate().queryForObject(sql, (Map)paramMap, Integer.class);
    }

    @Override
    public boolean isStudentInlesson(Long lessonId, Long userId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"lessonId"});
        builder.eq("lessonId", (Serializable)lessonId);
        builder.eq("userId", (Serializable)userId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        List list = this.queryForList(builder, Long.class);
        return CollectionUtils.isNotEmpty((Collection)list);
    }

    @Override
    public Map<Long, Integer> getStudentLessonCountOfCourses(Long orgId, Long userId, Collection<Long> courseIds) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Collections.emptyMap();
        }
        final HashMap map = Maps.newHashMap();
        String sql = "select count(ocl.id) as cnt,ocl.course_id from tts.org_student_lesson osl join tts.org_class_lesson ocl ON osl.lesson_id = ocl.id where  ocl.org_id = :orgId AND osl.student_id = :userId AND ocl.course_id in(:courseIds) and osl.del_status = 0 and ocl.del_status = 0 group by(ocl.course_id)";
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("orgId", orgId);
        paramMap.put("userId", userId);
        paramMap.put("courseIds", courseIds);
        this.getNamedJdbcTemplate().query(sql, (Map)paramMap, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                map.put(rs.getLong("course_id"), rs.getInt("cnt"));
            }
        });
        return map;
    }

    @Override
    public Map<Long, List<Long>> getLessonStudentList(Collection<Long> lessonIds) {
        if (CollectionUtils.isEmpty(lessonIds)) {
            return Maps.newHashMap();
        }
        ListBatchQueryTemplate batch = new ListBatchQueryTemplate();
        List list = (List)batch.batchQuery(lessonIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgStudentLesson>>(){

            public List<OrgStudentLesson> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentLessonDaoImpl.this.createSqlBuilder(new String[]{"lessonId", "userId"});
                builder.in("lessonId", querySet);
                builder.eq("delStatus", (Serializable)Integer.valueOf(0));
                return OrgStudentLessonDaoImpl.this.queryList(builder);
            }
        });
        return CollectorUtil.group((Collection)list, (Function)new Function<OrgStudentLesson, Long>(){

            public Long apply(OrgStudentLesson arg0) {
                return arg0.getLessonId();
            }
        }, (Function)new Function<OrgStudentLesson, Long>(){

            public Long apply(OrgStudentLesson arg0) {
                return arg0.getUserId();
            }
        });
    }

    @Override
    public List<OrgStudentLesson> getAllByOrgId(Long orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudentLesson> getLessonStudentListDelStatus(Collection<Long> lessonIds) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("lessonId", lessonIds);
        builder.eq("delStatus", (Serializable)Integer.valueOf(1));
        return this.queryList(builder);
    }

    @Override
    public Map<Long, List<Long>> getStudentLessonList(Collection<Long> studentIds) {
        if (CollectionUtils.isEmpty(studentIds)) {
            return Maps.newHashMap();
        }
        ListBatchQueryTemplate batch = new ListBatchQueryTemplate();
        List list = (List)batch.batchQuery(studentIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgStudentLesson>>(){

            public List<OrgStudentLesson> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentLessonDaoImpl.this.createSqlBuilder(new String[]{"lessonId", "userId"});
                builder.in("userId", querySet);
                builder.eq("delStatus", (Serializable)Integer.valueOf(0));
                return OrgStudentLessonDaoImpl.this.queryList(builder);
            }
        });
        return CollectorUtil.group((Collection)list, (Function)new Function<OrgStudentLesson, Long>(){

            public Long apply(OrgStudentLesson arg0) {
                return arg0.getUserId();
            }
        }, (Function)new Function<OrgStudentLesson, Long>(){

            public Long apply(OrgStudentLesson arg0) {
                return arg0.getLessonId();
            }
        });
    }

    @Override
    public List<Long> getUserIdsByLessonIds(Long orgId, Collection<Long> lessonIds) {
        if (CollectionUtils.isEmpty(lessonIds)) {
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate batch = new ListBatchQueryTemplate();
        return (List)batch.batchQuery(lessonIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<Long>>(){

            public List<Long> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentLessonDaoImpl.this.createSqlBuilder(new String[]{"userId"});
                builder.in("lessonId", querySet);
                builder.eq("delStatus", (Serializable)Integer.valueOf(0));
                return OrgStudentLessonDaoImpl.this.queryForList(builder, Long.class);
            }
        });
    }

    @Override
    public Map<Long, List<Long>> getStudentLessonByStartTime(Date startTime, Date endTime) {
        StringBuilder sb = new StringBuilder();
        sb.append("select student.lesson_id as lessonId, student.student_id as userId from tts.org_student_lesson student ");
        sb.append("join tts.org_class_lesson lesson on student.lesson_id = lesson.id and lesson.del_status=0 and student.del_status=0 ");
        sb.append(" and lesson.start_time >=:startTime and lesson.start_time <:endTime");
        HashMap param = Maps.newHashMap();
        param.put("startTime", startTime);
        param.put("endTime", endTime);
        final HashMap result = Maps.newHashMap();
        this.getNamedJdbcTemplate().query(sb.toString(), (Map)param, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Long userId = rs.getLong("userId");
                Long lessonId = rs.getLong("lessonId");
                if (!result.containsKey(lessonId)) {
                    result.put(lessonId, Lists.newArrayList());
                }
                ((List)result.get(lessonId)).add(userId);
            }
        });
        return result;
    }

    @Override
    public Map<Long, List<Long>> getStudentLessonByEndTime(Date startTime, Date endTime) {
        StringBuilder sb = new StringBuilder();
        sb.append("select student.lesson_id as lessonId, student.student_id as userId from tts.org_student_lesson student ");
        sb.append("join tts.org_class_lesson lesson on student.lesson_id = lesson.id and lesson.del_status=0 and student.del_status = 0");
        sb.append(" and lesson.end_time >=:startTime and lesson.end_time <:endTime");
        HashMap param = Maps.newHashMap();
        param.put("startTime", startTime);
        param.put("endTime", endTime);
        final HashMap result = Maps.newHashMap();
        this.getNamedJdbcTemplate().query(sb.toString(), (Map)param, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Long userId = rs.getLong("userId");
                Long lessonId = rs.getLong("lessonId");
                if (!result.containsKey(lessonId)) {
                    result.put(lessonId, Lists.newArrayList());
                }
                ((List)result.get(lessonId)).add(userId);
            }
        });
        return result;
    }

    @Override
    public Map<Long, Integer> getStudentCountOfTeacher(Long orgId, Collection<Long> teacherIds, Date endTime) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId is null!");
        if (CollectionUtils.isEmpty(teacherIds)) {
            return Maps.newHashMap();
        }
        HashMap params = Maps.newHashMap();
        StringBuilder sb = new StringBuilder();
        sb.append("select count(student.student_id) as num, teacher.teacher_id as teacherId from tts.org_student_lesson student ");
        sb.append("join tts.org_teacher_lesson teacher on student.lesson_id = teacher.lesson_id ");
        sb.append("join tts.org_class_lesson lesson on student.lesson_id = lesson.id ");
        sb.append("where student.org_id =:orgId ");
        sb.append("and teacher.teacher_id in (:teacherIds) ");
        params.put("orgId", orgId);
        params.put("teacherIds", teacherIds);
        sb.append("and lesson.end_time <=:startTime and student.del_status = 0 ");
        if (endTime != null) {
            sb.append("and lesson.end_time >:endTime ");
            params.put("endTime", endTime);
        }
        params.put("startTime", new Date());
        sb.append(" group by (teacher.teacher_id)");
        final HashMap result = Maps.newHashMap();
        this.getNamedJdbcTemplate().query(sb.toString(), (Map)params, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                result.put(rs.getLong("teacherId"), rs.getInt("num"));
            }
        });
        return result;
    }

    @Override
    public Integer getFinishLessonStudentCount(Long orgId) {
        StringBuilder sb = new StringBuilder();
        sb.append("select count(student.id) as num from tts.org_student_lesson student ");
        sb.append("join tts.org_class_lesson lesson on student.lesson_id = lesson.id ");
        sb.append("where student.org_id =:orgId and lesson.end_time<=:endTime and student.del_status = 0 ");
        HashMap params = Maps.newHashMap();
        params.put("orgId", orgId);
        params.put("endTime", new Date());
        return (Integer)this.getNamedJdbcTemplate().query(sb.toString(), (Map)params, (ResultSetExtractor)new ResultSetExtractor<Integer>(){

            public Integer extractData(ResultSet rs) throws SQLException, DataAccessException {
                if (rs.next()) {
                    return rs.getInt("num");
                }
                return 0;
            }
        });
    }

    @Override
    public List<OrgStudentLesson> queryStudentsByLessonId(Long orgId, Long lessonId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (orgId != null) {
            builder.eq("orgId", (Serializable)orgId);
        }
        builder.eq("lessonId", (Serializable)lessonId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudentLesson> getOrgStudentLessonsByLessonIds(Collection<Long> lessonIds, String ... props) {
        if (lessonIds == null || lessonIds.size() < 1) {
            return Collections.EMPTY_LIST;
        }
        SingleSqlBuilder builder = this.createSqlBuilder(props);
        builder.in("lessonId", lessonIds);
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        List orgStudentLessons = this.queryList(builder);
        return orgStudentLessons;
    }

    @Override
    public List<OrgStudentLesson> getStudentLessonsByPage(Date startTime, Date endTime, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (startTime != null) {
            builder.ge("updateTime", (Serializable)startTime);
            builder.le("updateTime", (Serializable)endTime);
        }
        builder.setPage(pageDto);
        return this.queryList(builder);
    }

    @Override
    public void batchUpdateStatus(Collection<Long> lessonIds, int status) {
        String sql = "update tts.org_student_lesson set start_status=:status,update_time=:updateTime where lesson_id in (:ids) AND start_status != :status";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", status);
        map.put("updateTime", new Date());
        map.put("ids", lessonIds);
        this.getNamedJdbcTemplate().update(sql, map);
    }

    @Override
    public void batchUpdateKexiaoStatus(Collection<Long> lessonIds, int status) {
        String sql = "update tts.org_student_lesson set kexiao_status=:status,update_time=:updateTime where lesson_id in (:ids) AND kexiao_status != :status";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", status);
        map.put("updateTime", new Date());
        map.put("ids", lessonIds);
        this.getNamedJdbcTemplate().update(sql, map);
    }

    @Override
    public void batchUpdateKexiaoStatusBySign(List<OrgLessonSign> signs, int status) {
        if (signs == null || signs.size() < 1) {
            return;
        }
        log.info("[Param] sign={},status={}", signs, (Object)status);
        String sql = "update tts.org_student_lesson set kexiao_status=:status,update_time=:updateTime where lesson_id = :lessonId AND student_id=:userId AND kexiao_status != :status";
        Map[] list = new HashMap[signs.size()];
        for (int i = 0; i < list.length; ++i) {
            HashMap<String, Comparable<Integer>> map = new HashMap<String, Comparable<Integer>>();
            map.put("status", Integer.valueOf(status));
            map.put("updateTime", new Date());
            map.put("lessonId", signs.get(i).getLessonId());
            map.put("userId", signs.get(i).getUserId());
            list[i] = map;
        }
        this.getNamedJdbcTemplate().batchUpdate(sql, list);
    }

    @Override
    public void batchUpdateLessonType(Collection<Long> userIds, Long lessonId, int newType, int oldType) {
        if (userIds == null || userIds.size() < 1 || lessonId == null) {
            return;
        }
        String sql = "update tts.org_student_lesson set lesson_type =:newType,update_time=:updateTime where lesson_id = :lessonId AND student_id in (:userIds) and lesson_type=:oldType";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("newType", newType);
        map.put("updateTime", new Date());
        map.put("lessonId", lessonId);
        map.put("userIds", userIds);
        map.put("oldType", oldType);
        this.getNamedJdbcTemplate().update(sql, map);
    }

    @Override
    public List<StudentLessonStatistics> getStudentLessonCounter(final long orgId, Collection<Long> userIds, long courseId) {
        String sql = "select student_id,course_id,count(1) as total,sum(kexiao_status) as finished,sum(lesson_duration) as total_time,sum(if(kexiao_status=1,lesson_duration,0)) as finished_time,sum(if(kexiao_status=0,lesson_duration,0)) as left_time from tts.org_student_lesson where org_id=:orgId AND student_id in (:userIds) and course_id=:courseId and del_status = 0 group by course_id,student_id";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("userIds", userIds);
        param.put("orgId", orgId);
        param.put("courseId", courseId);
        List statisticsList = this.getNamedJdbcTemplate().query(sql, param, (RowMapper)new RowMapper<StudentLessonStatistics>(){

            public StudentLessonStatistics mapRow(ResultSet rs, int rowNum) throws SQLException {
                StudentLessonStatistics statistics = OrgStudentLessonDaoImpl.this.buildStudentLessonStatistics(orgId, rs);
                return statistics;
            }
        });
        return statisticsList;
    }

    @Override
    public List<StudentLessonStatistics> getStudentLessonCounterList(final long orgId, PageDto pageDto) {
        int start = (pageDto.getPageNum() - 1) * pageDto.getPageSize();
        String sql = "select sl.student_id ,sl.course_id ,count(1) as total,sum(if(kexiao_status = 1,1,0)) as finished,sum(lesson_duration) as total_time,sum(if(kexiao_status=1,lesson_duration,0)) as finished_time,sum(if(kexiao_status=0,lesson_duration,0)) as left_time,sum(if(kexiao_status=0,1,0)) as leftCount,sum(lesson_duration) as totalArrangeTime,sum(if(kexiao_status=1 and lesson_type in (-1,1),kexiao_duration,0)) as kexiaoTime from tts.org_student_lesson sl where sl.del_status= 0  and lesson_type in (-1,1,2) and sl.org_id=:orgId  group by sl.course_id,sl.student_id ORDER by sl.student_id limit :start,:limit";
        HashMap<String, Number> param = new HashMap<String, Number>();
        param.put("orgId", orgId);
        param.put("start", start);
        param.put("limit", pageDto.getPageSize());
        List counters = this.getNamedJdbcTemplate().query(sql, param, (RowMapper)new RowMapper<StudentLessonStatistics>(){

            public StudentLessonStatistics mapRow(ResultSet rs, int rowNum) throws SQLException {
                StudentLessonStatistics statistics = OrgStudentLessonDaoImpl.this.buildStudentLessonStatistics(orgId, rs);
                statistics.setLeftCount(rs.getLong("leftCount"));
                statistics.setTotalArrangeTime(rs.getLong("totalArrangeTime"));
                statistics.setKexiaoTime(rs.getLong("kexiaoTime"));
                statistics.setOrgId(orgId);
                return statistics;
            }
        });
        return counters;
    }

    private StudentLessonStatistics buildStudentLessonStatistics(Long orgId, ResultSet rs) throws SQLException {
        StudentLessonStatistics statistics = new StudentLessonStatistics();
        statistics.setOrgId(orgId);
        statistics.setCourseId(rs.getLong("course_id"));
        statistics.setUserId(rs.getLong("student_id"));
        statistics.setTotalCount(rs.getLong("total"));
        statistics.setFinishedCount(rs.getLong("finished"));
        statistics.setTotalTime(rs.getLong("total_time"));
        statistics.setLeftTime(rs.getLong("left_time"));
        statistics.setFinishedTime(rs.getLong("finished_time"));
        return statistics;
    }

    @Override
    public Map<Long, Integer> getStudentsLeftLessonMap(Long orgId, Long courseId, Collection<Long> userIds) {
        final HashMap map = Maps.newHashMap();
        String sql = "select sl.student_id, count(sl.id) as leftLessons, cl.course_id from tts.org_student_lesson sl left join tts.org_class_lesson cl on sl.lesson_id = cl.id  where sl.org_id=:orgId and sl.student_id in (:userIds) and cl.course_id=:courseId and sl.del_status = 0 and cl.del_status = 0 and cl.start_time > now()  group by sl.student_id, cl.course_id";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("userIds", userIds);
        param.put("orgId", orgId);
        param.put("courseId", courseId);
        this.getNamedJdbcTemplate().query(sql, param, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                map.put(rs.getLong("student_id"), rs.getInt("leftLessons"));
            }
        });
        return map;
    }

    @Override
    public Map<Long, List<Long>> getStudentCourseLessonMap(Long orgId, Long courseId, Collection<Long> userIds) {
        final HashMap map = Maps.newHashMap();
        String sql = "select sl.student_id, sl.lesson_id from tts.org_student_lesson sl left join tts.org_class_lesson cl on sl.lesson_id = cl.id  where sl.org_id=:orgId and sl.student_id in (:userIds) and cl.course_id=:courseId and sl.del_status = 0 and cl.del_status = 0";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("userIds", userIds);
        param.put("orgId", orgId);
        param.put("courseId", courseId);
        this.getNamedJdbcTemplate().query(sql, param, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Long userId = rs.getLong("student_id");
                Long lessonId = rs.getLong("lesson_id");
                List lessons = (List)map.get(userId);
                if (lessons == null) {
                    lessons = Lists.newArrayList();
                    map.put(userId, lessons);
                }
                lessons.add(lessonId);
            }
        });
        log.debug("getStudentCourseLessonMap {},{},{}", new Object[]{sql, param, map});
        return map;
    }

    @Override
    public List<OrgStudentLesson> getOrgStudentLessonsByCourseIds(Collection<Long> courseIds) {
        String sql = "select sl.* from tts.org_student_lesson sl left join tts.org_class_lesson cl on sl.lesson_id = cl.id where cl.course_id in (:courseIds) AND sl.del_status=0";
        HashMap<String, Collection<Long>> param = new HashMap<String, Collection<Long>>();
        param.put("courseIds", courseIds);
        List counters = this.getNamedJdbcTemplate().query(sql, param, (RowMapper)new RowMapper<OrgStudentLesson>(){

            public OrgStudentLesson mapRow(ResultSet rs, int rowNum) throws SQLException {
                OrgStudentLesson lesson = new OrgStudentLesson();
                lesson.setLessonId(rs.getLong("lesson_id"));
                lesson.setKexiaoStatus(rs.getInt("kexiao_status"));
                lesson.setId(rs.getLong("id"));
                lesson.setUserId(rs.getLong("student_id"));
                return lesson;
            }
        });
        return counters;
    }

    @Override
    public List<StudentClasHourDocument> queryStudentClassHours(Set<Long> studentIds, Long orgId) {
        if (GenericsUtils.isNullOrEmpty(studentIds)) {
            return GenericsUtils.emptyList();
        }
        String sql = "select sl.student_id as userId,sl.course_id as courseId,count(1) as total,sum(kexiao_status) as finished,sum(if(kexiao_status=0,1,0)) as leftCount,lesson_type,sum(lesson_duration) as totalArrangeTime,sum(if(kexiao_status=1,lesson_duration,0)) as kexiaoTime from tts.org_student_lesson sl  where sl.del_status= 0 and sl.student_id in (:studentIds) and sl.org_id=:orgId  group by sl.student_id,sl.course_id";
        HashMap param = Maps.newHashMap();
        param.put("studentIds", studentIds);
        param.put("orgId", orgId);
        final ArrayList ret = Lists.newArrayList();
        this.getNamedJdbcTemplate().query(sql, (Map)param, (ResultSetExtractor)new ResultSetExtractor<StudentClasHourDocument>(){

            public StudentClasHourDocument extractData(ResultSet rs) throws SQLException, DataAccessException {
                while (rs.next()) {
                    Long userId = rs.getLong("userId");
                    Long courseId = rs.getLong("courseId");
                    Long total = rs.getLong("total");
                    Long finished = rs.getLong("finished");
                    Long leftCount = rs.getLong("leftCount");
                    Long totalArrangeTime = rs.getLong("totalArrangeTime");
                    Long kexiaoTime = rs.getLong("kexiaoTime");
                    StudentClasHourDocument scd = new StudentClasHourDocument();
                    scd.setUserId(userId);
                    scd.setCourseId(courseId);
                    scd.setTotal(total);
                    scd.setFinished(finished);
                    scd.setLeftCount(leftCount);
                    scd.setTotalArrangeTime(totalArrangeTime);
                    scd.setKexiaoTime(kexiaoTime);
                    ret.add(scd);
                }
                return null;
            }
        });
        return ret;
    }

    @Override
    public List<OrgStudentLesson> getByCourseIdsUserIds(@NonNull Long orgId, Collection<Long> courseIds, Collection<Long> userIds, String ... props) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        SingleSqlBuilder builder = this.createSqlBuilder(props);
        builder.eq("orgId", (Serializable)orgId);
        if (CollectionUtils.isNotEmpty(courseIds)) {
            builder.in("courseId", courseIds);
        }
        if (CollectionUtils.isNotEmpty(userIds)) {
            builder.in("userId", userIds);
        }
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudentLesson> getByUserIdAndClassId(Long orgId, long userId, long classId, Integer kexiaoStatus, String ... props) {
        SingleSqlBuilder builder = this.createSqlBuilder(props);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("userId", (Serializable)Long.valueOf(userId));
        builder.eq("courseId", (Serializable)Long.valueOf(classId));
        if (kexiaoStatus != null) {
            builder.eq("kexiaoStatus", (Serializable)kexiaoStatus);
        }
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudentLesson> getByUserIdAndClassId(Long orgId, long userId, long classId, Integer kexiaoStatus, Collection<Integer> lessonTypes, String ... props) {
        SingleSqlBuilder builder = this.createSqlBuilder(props);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("userId", (Serializable)Long.valueOf(userId));
        builder.eq("courseId", (Serializable)Long.valueOf(classId));
        if (kexiaoStatus != null) {
            builder.eq("kexiaoStatus", (Serializable)kexiaoStatus);
        }
        if (lessonTypes != null && lessonTypes.size() > 0) {
            builder.in("lessonType", lessonTypes);
        }
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public OrgStudentLesson getByLessonIdAndUserId(Long lessonId, Long userId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("lessonId", (Serializable)lessonId);
        builder.eq("userId", (Serializable)userId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return (OrgStudentLesson)this.uniqueResult(builder);
    }

    @Override
    public List<OrgStudentLesson> getByLessonIdsStudentIds(Collection<Long> lessonIds, Collection<Long> userIds, String ... prop) {
        SingleSqlBuilder builder = this.createSqlBuilder(prop);
        if (CollectionUtils.isEmpty(lessonIds) || CollectionUtils.isEmpty(userIds)) {
            return Lists.newArrayList();
        }
        builder.in("lessonId", lessonIds);
        builder.in("userId", userIds);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudentLesson> getByLessonIdsAndUserIds(Collection<Long> lessonIds, Collection<Long> userIds, Integer delStatus, String ... prop) {
        SingleSqlBuilder builder = this.createSqlBuilder(prop);
        if (CollectionUtils.isEmpty(lessonIds) || CollectionUtils.isEmpty(userIds)) {
            return Lists.newArrayList();
        }
        builder.in("lessonId", lessonIds);
        builder.in("userId", userIds);
        if (delStatus != null) {
            builder.eq("delStatus", (Serializable)delStatus);
        }
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudentLesson> getAllStuLessonsBy(Long orgId, Collection<Long> lessonIds, Collection<Long> userIds, String ... prop) {
        SingleSqlBuilder builder = this.createSqlBuilder(prop);
        if (CollectionUtils.isEmpty(lessonIds)) {
            return Lists.newArrayList();
        }
        builder.eq("orgId", (Serializable)orgId);
        builder.in("lessonId", lessonIds);
        builder.in("userId", userIds);
        return this.queryList(builder);
    }

    @Override
    public Map<Long, Integer> getFinishCount(Long orgId, Collection<Long> courseIds, Collection<Long> userIds) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId is null!");
        if (CollectionUtils.isEmpty(courseIds)) {
            return Maps.newHashMap();
        }
        HashMap params = Maps.newHashMap();
        StringBuilder sb = new StringBuilder();
        sb.append("select course_id,count(id) as finished ");
        sb.append("from tts.org_student_lesson ");
        sb.append("where org_id=:orgId AND student_id in(:userId) and course_id in(:courseId) and del_status = 0 and kexiao_status = 1 ");
        sb.append("group by course_id ");
        params.put("orgId", orgId);
        params.put("userId", userIds);
        params.put("courseId", courseIds);
        final HashMap result = Maps.newHashMap();
        this.getNamedJdbcTemplate().query(sb.toString(), (Map)params, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                result.put(rs.getLong("course_id"), rs.getInt("finished"));
            }
        });
        return result;
    }

    @Override
    public void batchUpdateLessonDuration(Collection<Long> userIds, Integer duration, Long lessonId) {
        if (CollectionUtils.isEmpty(userIds)) {
            return;
        }
        String sql = "update tts.org_student_lesson set lesson_duration=:duration,update_time=:updateTime where student_id in (:userIds) AND lesson_id = :lessonId";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("duration", duration);
        map.put("updateTime", new Date());
        map.put("userIds", userIds);
        map.put("lessonId", lessonId);
        this.getNamedJdbcTemplate().update(sql, map);
    }

    @Override
    public List<OrgStudentLesson> getStuLessonsByUpdateTime(Date startTime, Date endTime, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.ge("updateTime", (Serializable)startTime);
        builder.le("updateTime", (Serializable)endTime);
        if (pageDto != null) {
            builder.setPage(pageDto);
        }
        return this.queryList(builder);
    }

    @Override
    public void batchUpdateKexiaoStatusById(Collection<Long> ids, int status) {
        String sql = "update tts.org_student_lesson set kexiao_status=:status,update_time=:updateTime where id in (:ids) AND kexiao_status != :status";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", status);
        map.put("updateTime", new Date());
        map.put("ids", ids);
        this.getNamedJdbcTemplate().update(sql, map);
    }

    @Override
    public void batchUpdateStartStatusById(Collection<Long> ids, int status) {
        String sql = "update tts.org_student_lesson set start_status=:status,update_time=:updateTime where id in (:ids) AND start_status != :status";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", status);
        map.put("updateTime", new Date());
        map.put("ids", ids);
        this.getNamedJdbcTemplate().update(sql, map);
    }

    @Override
    public Integer countLessonStudent(Collection<Long> lessonIds) {
        if (CollectionUtils.isEmpty(lessonIds)) {
            return 0;
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.in("lessonId", lessonIds);
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        Integer result = (Integer)this.queryForObject(builder, Integer.class);
        return result != null ? result : 0;
    }

    @Override
    public Map<Long, Integer> mapStuLessonCount(Collection<Long> lessonIds, Collection<Long> studentUserIds) {
        final HashMap<Long, Integer> result = new HashMap<Long, Integer>();
        String sql = "SELECT student_id,count(id) AS num FROM tts.org_student_lesson WHERE lesson_id IN (:lessonIds) AND student_id IN(:studentUserIds) AND del_status=0 GROUP BY student_id ";
        HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>();
        params.put("lessonIds", lessonIds);
        params.put("studentUserIds", studentUserIds);
        this.getNamedJdbcTemplate().query(sql, params, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                result.put(rs.getLong("student_id"), rs.getInt("num"));
            }
        });
        return result;
    }

    @Override
    public Map<Long, Map<Long, Integer>> mapCourseStuLessonCount(Collection<Long> lessonIds) {
        final HashMap<Long, Map<Long, Integer>> result = new HashMap<Long, Map<Long, Integer>>();
        String sql = "SELECT course_id,student_id,count(id) AS num FROM tts.org_student_lesson WHERE lesson_id IN (:lessonIds) AND del_status=0 GROUP BY course_id,student_id ";
        HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>();
        params.put("lessonIds", lessonIds);
        this.getNamedJdbcTemplate().query(sql, params, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Long courseId = rs.getLong("course_id");
                Long studentUserId = rs.getLong("student_id");
                Integer num = rs.getInt("num");
                HashMap<Long, Integer> stuCountMap = (HashMap<Long, Integer>)result.get((long)courseId);
                if (stuCountMap == null) {
                    stuCountMap = new HashMap<Long, Integer>();
                    result.put(Long.valueOf(courseId), stuCountMap);
                }
                stuCountMap.put(studentUserId, num);
            }
        });
        return result;
    }

    @Override
    public Map<Long, TwoTuple<Integer, Integer>> countStudentNumsWithLessonIds(final List<Long> finishLessonIds, List<Long> arrangeLessonIds) {
        HashMap params = Maps.newHashMap();
        if (GenericsUtils.isNullOrEmpty(arrangeLessonIds)) {
            return GenericsUtils.emptyMap();
        }
        String sql = "select lesson_id ,count(student_id) as count ,sum(if(kexiao_status=1,1,0)) as kexiaoCount from tts.org_student_lesson where lesson_id in (:lessonIds) and del_status = 0 group by lesson_id";
        params.put("lessonIds", arrangeLessonIds);
        final HashMap retMap = Maps.newHashMap();
        this.getNamedJdbcTemplate().query(sql, (Map)params, (ResultSetExtractor)new ResultSetExtractor<String>(){

            public String extractData(ResultSet rs) throws SQLException, DataAccessException {
                while (rs.next()) {
                    Long lessonId = rs.getLong("lesson_id");
                    Long count = rs.getLong("count");
                    Long kexiaoCount = rs.getLong("kexiaoCount");
                    Integer hasFinishCount = 0;
                    if (finishLessonIds.contains(lessonId)) {
                        hasFinishCount = kexiaoCount.intValue();
                    }
                    retMap.put(lessonId, TupleUtil.tuple((Object)hasFinishCount, (Object)count.intValue()));
                }
                return null;
            }
        });
        return retMap;
    }

    @Override
    public List<Long> filterNoKexiaoLessons(Collection<Long> lessonIds) {
        if (lessonIds == null || lessonIds.isEmpty()) {
            return GenericsUtils.emptyList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"lessonId"});
        builder.in("lessonId", lessonIds);
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        builder.eq("kexiaoStatus", (Serializable)Integer.valueOf(1));
        return this.queryForList(builder, Long.class);
    }

    @Override
    public List<Long> listUserIdsByCourseIds(Collection<Long> courseIds) {
        if (courseIds == null || courseIds.isEmpty()) {
            return GenericsUtils.emptyList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"student_id"});
        builder.in("courseId", courseIds);
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        return this.queryForList(builder, Long.class);
    }

    @Override
    public List<OrgStudentLesson> listByUserIdsAndLessonType(long orgId, Collection<Long> userIds, Collection<Integer> lessonTypes, String ... props) {
        if (userIds == null || userIds.isEmpty()) {
            return GenericsUtils.emptyList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(props);
        builder.in("userId", userIds);
        builder.eq("orgId", (Serializable)Long.valueOf(orgId));
        if (lessonTypes != null && lessonTypes.size() > 0) {
            builder.in("lessonType", lessonTypes);
        }
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        return this.queryList(builder);
    }

    @Override
    public Set<Long> hasScheduleLesson(Collection<Long> userIds) {
        String sql = "select distinct student_id from tts.org_student_lesson where student_id in (:userIds)";
        final HashSet<Long> ids = new HashSet<Long>();
        HashMap<String, Collection<Long>> param = new HashMap<String, Collection<Long>>();
        param.put("userIds", userIds);
        this.getNamedJdbcTemplate().query(sql, param, (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet resultSet, int i) throws SQLException {
                ids.add(resultSet.getLong("student_id"));
                return null;
            }
        });
        return ids;
    }

    @Override
    public List<String> getMixArrangeLesson() {
        String sql = "select org_id,course_id,student_id,sum(if(lesson_type>0,1,0)) as c1, sum(if(lesson_type<0,1,0)) as c2 from tts.org_student_lesson where del_status=0 group by org_id,course_id,student_id having c1>0 and c2>0";
        return this.getNamedJdbcTemplate().query(sql, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet resultSet, int i) throws SQLException {
                long courseId = resultSet.getLong("course_id");
                long userId = resultSet.getLong("student_id");
                long orgId = resultSet.getLong("org_id");
                long count = resultSet.getLong("c2");
                return orgId + "_" + userId + "_" + courseId + "_" + count;
            }
        });
    }

    @Override
    public List<String> getMixArrangeLessonByOrgId(Long orgId) {
        String sql = "select org_id,course_id,student_id,sum(if(lesson_type>0,1,0)) as c1, sum(if(lesson_type<0,1,0)) as c2 from tts.org_student_lesson where del_status=0 and org_id=:orgId group by org_id,course_id,student_id having c1>0 and c2>0";
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("orgId", orgId);
        return this.getNamedJdbcTemplate().query(sql, map, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet resultSet, int i) throws SQLException {
                long courseId = resultSet.getLong("course_id");
                long userId = resultSet.getLong("student_id");
                long orgId = resultSet.getLong("org_id");
                long count = resultSet.getLong("c2");
                return orgId + "_" + userId + "_" + courseId + "_" + count;
            }
        });
    }

    @Override
    public Set<Long> getStudentIdsByLessonIds(Long orgId, Collection<Long> lessonIds) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"userId"});
        if (CollectionUtils.isNotEmpty(lessonIds)) {
            builder.in("lessonId", lessonIds);
        }
        builder.eq("orgId", (Serializable)orgId);
        List list = this.queryList(builder);
        HashSet studentUserIds = Sets.newHashSet();
        if (GenericsUtils.notNullAndEmpty((Object)list)) {
            for (OrgStudentLesson otl : list) {
                studentUserIds.add(otl.getUserId());
            }
        }
        return studentUserIds;
    }
}

